/*
 * Decompiled with CFR 0.152.
 */
package purejavacomm.testsuite;

import purejavacomm.testsuite.TestBase;

public class Test8
extends TestBase {
    static void run() throws Exception {
        try {
            Test8.begin("Test8 - parity");
            Test8.openPort();
            int[] nArray = new int[3];
            nArray[1] = 1;
            nArray[2] = 2;
            int[] parity = nArray;
            int[] stopbits = new int[]{1, 2};
            int[] databits = new int[]{5, 6, 7, 8};
            int[] datamask = new int[]{31, 63, 127, 255};
            int pi = 0;
            while (pi < parity.length) {
                int sbi = 0;
                while (sbi < stopbits.length) {
                    int dbi = 0;
                    while (dbi < databits.length) {
                        m_Port.enableReceiveTimeout(10000);
                        m_Port.enableReceiveThreshold(256);
                        m_Port.setSerialPortParams(115200, databits[dbi], stopbits[sbi], parity[pi]);
                        byte[] sent = new byte[256];
                        byte[] rcvd = new byte[256];
                        int i = 0;
                        while (i < 256) {
                            sent[i] = (byte)(i & datamask[dbi]);
                            ++i;
                        }
                        m_Out = m_Port.getOutputStream();
                        m_In = m_Port.getInputStream();
                        long t0 = System.currentTimeMillis();
                        m_Out.write(sent);
                        int n = m_In.read(rcvd);
                        if (n != sent.length) {
                            Test8.fail("was expecting %d characters got %d", sent.length, n);
                        }
                        int i2 = 0;
                        while (i2 < 256) {
                            if (sent[i2] != rcvd[i2]) {
                                Test8.fail("failed: transmit '0x%02X' != receive'0x%02X' with databits %d stopbit %d parity %d", sent[i2], rcvd[i2], databits[dbi], stopbits[sbi], parity[pi]);
                            }
                            ++i2;
                        }
                        if (n < 256) {
                            Test8.fail("did not receive all 256 chars, got %d", n);
                        }
                        ++dbi;
                    }
                    ++sbi;
                }
                ++pi;
            }
            Test8.finishedOK();
        }
        finally {
            Test8.closePort();
        }
    }
}

