/*
 * Decompiled with CFR 0.152.
 */
package purejavacomm.testsuite;

import purejavacomm.testsuite.TestBase;

public class Test4
extends TestBase {
    private static Exception m_Exception = null;
    private static Thread m_Receiver;
    private static Thread m_Transmitter;

    static void run() throws Exception {
        try {
            Test4.begin("Test4 - indefinite blocking");
            Test4.openPort();
            m_Receiver = new Thread(new Runnable(){

                public void run() {
                    try {
                        Test4.sync(2);
                        long T0 = System.currentTimeMillis();
                        byte[] b = new byte[1];
                        int n = m_In.read(b);
                        long dT = System.currentTimeMillis() - T0;
                        if (n != 1) {
                            Test4.fail("read did not block, read returned %d", n);
                        }
                        if (b[0] != 73) {
                            Test4.fail("read did not get looped back '73' got '%d'", b[0]);
                        }
                        if (dT < 10000L) {
                            Test4.fail("read did not block for 10000 msec, received loopback in %d msec", dT);
                        }
                    }
                    catch (InterruptedException T0) {
                    }
                    catch (Exception e) {
                        if (m_Exception == null) {
                            m_Exception = e;
                        }
                        m_Receiver.interrupt();
                        m_Transmitter.interrupt();
                    }
                }
            });
            m_Transmitter = new Thread(new Runnable(){

                public void run() {
                    try {
                        Test4.sync(2);
                        Test4.sleep(10000);
                        m_Out.write(73);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (m_Exception == null) {
                            m_Exception = e;
                        }
                        m_Receiver.interrupt();
                        m_Transmitter.interrupt();
                    }
                }
            });
            m_Receiver.start();
            m_Transmitter.start();
            while (m_Receiver.isAlive() || m_Transmitter.isAlive()) {
                Test4.sleep(100);
            }
            if (m_Exception != null) {
                throw m_Exception;
            }
            Test4.finishedOK();
        }
        finally {
            Test4.closePort();
        }
    }
}

