/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.tool.asm45;

import nl.lxtreme.ols.api.acquisition.AcquisitionResult;
import nl.lxtreme.ols.api.data.BaseDataSet;
import nl.lxtreme.ols.tool.asm45.Asm45Data;

public final class Asm45DataSet
extends BaseDataSet<Asm45Data> {
    private int decodedWords = 0;
    private int triggerEvent = 0;
    private double last_timing = -1.0;

    public Asm45DataSet(int aStartSampleIdx, int aStopSampleIdx, AcquisitionResult aData) {
        super(aStartSampleIdx, aStopSampleIdx, aData);
    }

    public int getDecodedWordCount() {
        return this.decodedWords;
    }

    public String getTotalTime() {
        double startTime = this.getTime(this.getStartOfDecode());
        double endTime = this.getTime(this.getEndOfDecode());
        return String.format("%.2f ms", (endTime - startTime) * 1000000.0);
    }

    public int getTriggerEvent() {
        return this.triggerEvent;
    }

    public void reportEvent(int aChannelIdx, int aStartSampleIdx, int aEndSampleIdx, int aClocks, int aBlock, int aAddress, int aValue, boolean aBusGrant, String aType, String aEvent) {
        int idx = this.size();
        double current_timing = this.getTime(aStartSampleIdx);
        if (this.last_timing < 0.0 && current_timing >= 0.0) {
            this.triggerEvent = this.decodedWords;
        }
        this.last_timing = current_timing;
        ++this.decodedWords;
        this.addData(new Asm45Data(idx, aChannelIdx, aStartSampleIdx, aEndSampleIdx, aClocks, aBlock, aAddress, aValue, aBusGrant, aType, aEvent));
    }
}

