/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.tool.uart;

import nl.lxtreme.ols.tool.uart.AsyncSerialDataDecoder;
import nl.lxtreme.ols.util.analysis.Frequency;

public final class BaudRateAnalyzer {
    private final double sampleRate;
    private final Frequency<Integer> statData;

    public BaudRateAnalyzer(int aSampleRate, int aFixedBaudRate) {
        this.sampleRate = aSampleRate;
        this.statData = new Frequency();
        int bitLength = (int)Math.round((double)aSampleRate / (double)aFixedBaudRate);
        this.statData.addValue((Comparable)Integer.valueOf(bitLength));
    }

    public BaudRateAnalyzer(int aSampleRate, int[] aValues, long[] aTimestamps, int aMask) {
        this.sampleRate = aSampleRate;
        this.statData = new Frequency();
        long lastTransition = 0L;
        int lastBitValue = aValues[0] & aMask;
        for (int i = 0; i < aValues.length; ++i) {
            int bitValue = aValues[i] & aMask;
            if (lastBitValue != bitValue) {
                int bitLength = (int)(aTimestamps[i] - lastTransition);
                this.statData.addValue((Comparable)Integer.valueOf(bitLength));
                lastTransition = aTimestamps[i];
            }
            lastBitValue = aValues[i] & aMask;
        }
    }

    public int getBaudRate() {
        int br = this.getBaudRateExact();
        int[] commonBaudrates = AsyncSerialDataDecoder.COMMON_BAUDRATES;
        int baudRateRounded = -1;
        for (int idx = 1; baudRateRounded < 0 && idx < commonBaudrates.length; ++idx) {
            int delta = (commonBaudrates[idx] - commonBaudrates[idx - 1]) / 2;
            if (br < commonBaudrates[idx] - delta || br > commonBaudrates[idx] + delta) continue;
            baudRateRounded = commonBaudrates[idx];
        }
        if (baudRateRounded < 0) {
            return br;
        }
        return baudRateRounded;
    }

    public int getBaudRateExact() {
        int bestBitLength = this.getBestBitLength();
        if (bestBitLength < 0) {
            return -1;
        }
        return (int)(this.sampleRate / (double)bestBitLength);
    }

    public int getBestBitLength() {
        Integer highestRanked = (Integer)this.statData.getHighestRanked();
        return highestRanked == null ? -1 : highestRanked;
    }
}

