/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.tool.state;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import nl.lxtreme.ols.api.UserSettings;
import nl.lxtreme.ols.api.acquisition.AcquisitionDataListener;
import nl.lxtreme.ols.api.acquisition.AcquisitionResult;
import nl.lxtreme.ols.api.data.Edge;
import nl.lxtreme.ols.api.tools.Tool;
import nl.lxtreme.ols.api.tools.ToolContext;
import nl.lxtreme.ols.api.tools.ToolTask;
import nl.lxtreme.ols.tool.base.BaseToolDialog;
import nl.lxtreme.ols.tool.base.ToolDialog;
import nl.lxtreme.ols.tool.base.ToolUtils;
import nl.lxtreme.ols.tool.state.StateAnalyser;
import nl.lxtreme.ols.tool.state.StateAnalysisTask;
import nl.lxtreme.ols.util.osgi.WhiteboardHelper;
import nl.lxtreme.ols.util.swing.SwingComponentUtils;
import nl.lxtreme.ols.util.swing.component.EnumItemRenderer;
import org.osgi.framework.BundleContext;

public final class StateAnalysisDialog
extends BaseToolDialog<AcquisitionResult> {
    private static final long serialVersionUID = 1L;
    private final WhiteboardHelper<AcquisitionDataListener> acquisitionDataListenerHelper;
    private JComboBox edgeSelect;
    private JComboBox channelSelect;
    private ToolUtils.RestorableAction runAction;

    public StateAnalysisDialog(Window aOwner, ToolContext aToolContext, BundleContext aContext, StateAnalyser aTool) {
        super(aOwner, aToolContext, aContext, (Tool)aTool);
        this.acquisitionDataListenerHelper = new WhiteboardHelper(aContext, AcquisitionDataListener.class);
        this.initDialog();
        this.setLocationRelativeTo(this.getOwner());
    }

    public void readPreferences(UserSettings aSettings) {
        this.setComboBoxIndex(this.channelSelect, aSettings, "channel");
        this.edgeSelect.setSelectedIndex(aSettings.getInt("edge", this.edgeSelect.getSelectedIndex()));
    }

    public void reset() {
        this.runAction.restore();
    }

    public void writePreferences(UserSettings aSettings) {
        aSettings.putInt("channel", this.channelSelect.getSelectedIndex());
        aSettings.putInt("edge", this.edgeSelect.getSelectedIndex());
    }

    protected void onBeforeCloseDialog() {
        this.acquisitionDataListenerHelper.close();
    }

    protected void onBeforeShowDialog() {
        this.acquisitionDataListenerHelper.open(true);
    }

    protected void onToolEnded(final AcquisitionResult aResult) {
        this.acquisitionDataListenerHelper.accept((WhiteboardHelper.Visitor)new WhiteboardHelper.Visitor<AcquisitionDataListener>(){

            public void visit(AcquisitionDataListener aService) {
                aService.acquisitionComplete(aResult);
            }
        });
        this.close();
    }

    protected void onToolStarted() {
    }

    protected void prepareToolTask(ToolTask<AcquisitionResult> aToolTask) {
        StateAnalysisTask toolTask = (StateAnalysisTask)aToolTask;
        toolTask.setNumber(this.channelSelect.getSelectedIndex());
        if (Edge.RISING == this.edgeSelect.getSelectedItem()) {
            toolTask.setLevel(0);
        } else {
            toolTask.setLevel(1);
        }
    }

    protected void setControlsEnabled(boolean aEnabled) {
        this.runAction.setEnabled(aEnabled);
    }

    private JPanel createContentPane() {
        int channelCount = this.getData().getChannels();
        this.channelSelect = SwingComponentUtils.createChannelSelector((int)channelCount, (int)0);
        this.edgeSelect = new JComboBox<Edge>(new Edge[]{Edge.RISING, Edge.FALLING});
        this.edgeSelect.setSelectedIndex(0);
        this.edgeSelect.setRenderer(new EdgeItemRenderer());
        JPanel pane = new JPanel(new GridLayout(2, 2, 5, 5));
        pane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 0));
        pane.add(new JLabel("Clock Channel"));
        pane.add(this.channelSelect);
        pane.add(new JLabel("Clock Edge"));
        pane.add(this.edgeSelect);
        return pane;
    }

    private void initDialog() {
        this.setResizable(false);
        JPanel pane = this.createContentPane();
        JButton runAnalysisButton = ToolUtils.createRunAnalysisButton((ToolDialog)this);
        this.runAction = (ToolUtils.RestorableAction)runAnalysisButton.getAction();
        JButton closeButton = ToolUtils.createCloseButton();
        JComponent buttons = SwingComponentUtils.createButtonPane((JButton[])new JButton[]{runAnalysisButton, closeButton});
        SwingComponentUtils.setupDialogContentPane((JDialog)((Object)this), (Component)pane, (Component)buttons, (JButton)runAnalysisButton);
    }

    static final class EdgeItemRenderer
    extends EnumItemRenderer<Edge> {
        private static final long serialVersionUID = 1L;

        EdgeItemRenderer() {
        }

        protected String getDisplayValue(Edge aValue) {
            String text = super.getDisplayValue((Enum)aValue);
            if (Edge.FALLING.equals((Object)aValue)) {
                text = "Falling";
            } else if (Edge.RISING.equals((Object)aValue)) {
                text = "Rising";
            }
            return text;
        }
    }
}

