/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay.util;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JPanel;
import nl.lxtreme.ols.client.signaldisplay.SignalDiagramController;
import nl.lxtreme.ols.client.signaldisplay.model.GhostGlassPaneModel;
import nl.lxtreme.ols.client.signaldisplay.view.renderer.Renderer;

public final class GhostGlassPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final GhostGlassPaneModel model;
    private volatile Rectangle affectedArea;
    private volatile Point paintLocation;
    private volatile Renderer renderer;

    public GhostGlassPane(SignalDiagramController aController) {
        this.setOpaque(false);
        this.model = new GhostGlassPaneModel(aController);
    }

    private static RenderingHints createRenderingHints() {
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        return hints;
    }

    public void repaintPartially() {
        if (this.affectedArea == null) {
            this.repaint();
        } else {
            Rectangle repaintRect = new Rectangle(this.affectedArea);
            repaintRect.grow(1, 1);
            this.repaint(repaintRect);
        }
    }

    public void setRenderer(Renderer aRenderer, Point aPaintLocation, Object ... aContext) {
        this.paintLocation = aPaintLocation;
        this.renderer = aRenderer;
        this.setRenderContext(aContext);
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        if (!aFlag) {
            this.paintLocation = null;
            this.renderer = null;
            this.affectedArea = null;
        }
    }

    public void updateRenderer(Point aPaintLocation, Object ... aContext) {
        this.setRenderer(this.renderer, aPaintLocation, aContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics aGraphics) {
        if (this.paintLocation == null || this.renderer == null || !this.isVisible()) {
            return;
        }
        Graphics2D g2d = (Graphics2D)aGraphics.create();
        try {
            g2d.setRenderingHints(GhostGlassPane.createRenderingHints());
            g2d.setComposite(this.model.getComposite());
            g2d.setColor(this.model.getColor());
            int x = this.paintLocation.x;
            int y = this.paintLocation.y;
            this.affectedArea = this.renderer.render(g2d, x, y);
        }
        finally {
            g2d.dispose();
        }
    }

    private void setRenderContext(Object ... aParameters) {
        if (this.renderer != null) {
            this.renderer.setContext(aParameters);
        }
    }
}

