/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.osgi;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.Dependency;
import org.apache.felix.dm.DependencyManager;
import org.osgi.framework.Bundle;
import org.osgi.service.log.LogService;

public class GenericBundleAdapter<TYPE> {
    private final Class<? extends TYPE> serviceClass;
    private final String headerKey;
    private volatile Bundle bundle;
    private volatile DependencyManager manager;
    private volatile Component serviceComponent;

    public GenericBundleAdapter(Class<? extends TYPE> aClass, String aHeaderKey) {
        this.serviceClass = aClass;
        this.headerKey = aHeaderKey;
    }

    public void destroy(Component aComponent) throws Exception {
        if (this.serviceComponent != null) {
            this.manager.remove(this.serviceComponent);
        }
    }

    public void init(Component aComponent) throws Exception {
        Dictionary bundleProps = this.bundle.getHeaders();
        String entry = (String)bundleProps.get(this.headerKey);
        if (entry == null || "".equals(entry)) {
            throw new IllegalArgumentException("No such header given: " + this.headerKey);
        }
        Class implClass = this.bundle.loadClass(entry);
        Properties serviceProps = this.copyOlsProperties(bundleProps);
        this.serviceComponent = this.manager.createComponent().setInterface(this.serviceClass.getName(), (Dictionary)serviceProps).setImplementation((Object)implClass).add((Dependency)this.manager.createServiceDependency().setService(LogService.class).setRequired(false));
        this.manager.add(this.serviceComponent);
    }

    private Properties copyOlsProperties(Dictionary<?, ?> aOriginal) {
        Properties result = new Properties();
        Enumeration<?> keys = aOriginal.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            if (!key.toString().startsWith("OLS-")) continue;
            result.put(key, aOriginal.get(key));
        }
        return result;
    }
}

