/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import nl.lxtreme.ols.api.DataAcquisitionService;
import nl.lxtreme.ols.api.acquisition.AcquisitionDataListener;
import nl.lxtreme.ols.api.acquisition.AcquisitionProgressListener;
import nl.lxtreme.ols.api.acquisition.AcquisitionResult;
import nl.lxtreme.ols.api.acquisition.AcquisitionResultStatus;
import nl.lxtreme.ols.api.acquisition.AcquisitionStatusListener;
import nl.lxtreme.ols.api.data.Channel;
import nl.lxtreme.ols.api.data.Cursor;
import nl.lxtreme.ols.api.data.DataSet;
import nl.lxtreme.ols.api.data.annotation.Annotation;
import nl.lxtreme.ols.api.data.annotation.AnnotationListener;
import nl.lxtreme.ols.api.data.export.Exporter;
import nl.lxtreme.ols.api.data.project.Project;
import nl.lxtreme.ols.api.data.project.ProjectManager;
import nl.lxtreme.ols.api.devices.Device;
import nl.lxtreme.ols.api.tools.Tool;
import nl.lxtreme.ols.api.tools.ToolContext;
import nl.lxtreme.ols.api.ui.ComponentProvider;
import nl.lxtreme.ols.api.util.UnitOfTime;
import nl.lxtreme.ols.client.ActionProvider;
import nl.lxtreme.ols.client.Activator;
import nl.lxtreme.ols.client.BundlesDialog;
import nl.lxtreme.ols.client.DockController;
import nl.lxtreme.ols.client.MainFrame;
import nl.lxtreme.ols.client.PreferencesDialog;
import nl.lxtreme.ols.client.action.ExportAction;
import nl.lxtreme.ols.client.action.GotoNthCursorAction;
import nl.lxtreme.ols.client.action.RunToolAction;
import nl.lxtreme.ols.client.action.SelectDeviceAction;
import nl.lxtreme.ols.client.action.SmartJumpAction;
import nl.lxtreme.ols.client.actionmanager.ActionManager;
import nl.lxtreme.ols.client.actionmanager.ActionManagerFactory;
import nl.lxtreme.ols.client.actionmanager.IManagedAction;
import nl.lxtreme.ols.client.osgi.ComponentStateAdapter;
import nl.lxtreme.ols.client.osgi.UIColorSchemeManager;
import nl.lxtreme.ols.client.signaldisplay.ICursorChangeListener;
import nl.lxtreme.ols.client.signaldisplay.SignalDiagramController;
import nl.lxtreme.ols.util.AccumulatingRunnable;
import nl.lxtreme.ols.util.ApplicationCallback;
import nl.lxtreme.ols.util.HostInfo;
import nl.lxtreme.ols.util.HostProperties;
import nl.lxtreme.ols.util.HostUtils;
import nl.lxtreme.ols.util.NumberUtils;
import nl.lxtreme.ols.util.swing.SwingComponentUtils;
import nl.lxtreme.ols.util.swing.component.JErrorDialog;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.ComponentStateListener;
import org.apache.felix.dm.Dependency;
import org.apache.felix.dm.DependencyManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.cm.ConfigurationAdmin;

public final class ClientController
implements ActionProvider,
AcquisitionProgressListener,
AcquisitionStatusListener,
AcquisitionDataListener,
AnnotationListener,
ApplicationCallback {
    private static final Logger LOG = Logger.getLogger(ClientController.class.getName());
    private final BundleContext bundleContext;
    private final ActionManager actionManager;
    private final SignalDiagramController signalDiagramController;
    private final ConcurrentMap<String, Device> devices;
    private final ConcurrentMap<String, Tool<?>> tools;
    private final ConcurrentMap<String, Exporter> exporters;
    private final ProgressUpdatingRunnable progressAccumulatingRunnable;
    private final AccumulatingRepaintingRunnable repaintAccumulatingRunnable;
    private volatile ProjectManager projectManager;
    private volatile DataAcquisitionService dataAcquisitionService;
    private volatile MainFrame mainFrame;
    private volatile HostProperties hostProperties;
    private volatile UIColorSchemeManager colorSchemeManager;
    private volatile long acquisitionStartTime;

    public ClientController(BundleContext aBundleContext) {
        this.bundleContext = aBundleContext;
        this.devices = new ConcurrentHashMap<String, Device>();
        this.tools = new ConcurrentHashMap();
        this.exporters = new ConcurrentHashMap<String, Exporter>();
        this.actionManager = new ActionManager();
        this.signalDiagramController = new SignalDiagramController(this.actionManager);
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                ClientController.this.signalDiagramController.initialize();
                ActionManagerFactory.fillActionManager(ClientController.this.actionManager, ClientController.this);
            }
        };
        SwingComponentUtils.invokeOnEDT((Runnable)runner);
        this.progressAccumulatingRunnable = new ProgressUpdatingRunnable();
        this.repaintAccumulatingRunnable = new AccumulatingRepaintingRunnable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquisitionComplete(AcquisitionResult aData) {
        try {
            this.getCurrentProject().setCapturedData(aData);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.updateActionsOnEDT();
        }
    }

    public void acquisitionEnded(AcquisitionResultStatus aStatus) {
        if (aStatus.isAborted()) {
            this.setStatusOnEDT("Capture aborted! {0}", aStatus.getMessage());
        } else if (aStatus.isFailed()) {
            this.setStatusOnEDT("Capture failed! {0}", aStatus.getMessage());
        } else {
            long time = System.currentTimeMillis() - this.acquisitionStartTime;
            this.setStatusOnEDT("Capture finished at {0,date,medium} {0,time,medium}, and took {1}.", new Date(), UnitOfTime.format((double)((double)time / 1000.0)));
        }
        this.updateActionsOnEDT();
    }

    public void acquisitionInProgress(int aPercentage) {
        this.progressAccumulatingRunnable.add(new Integer[]{aPercentage});
    }

    public void acquisitionStarted() {
        this.acquisitionStartTime = System.currentTimeMillis();
        this.updateActionsOnEDT();
    }

    public void addDevice(Device aDevice) {
        if (this.devices.putIfAbsent(aDevice.getName(), aDevice) == null) {
            this.actionManager.add(new SelectDeviceAction(this, aDevice.getName()));
        }
    }

    public void addExporter(Exporter aExporter) {
        if (this.exporters.putIfAbsent(aExporter.getName(), aExporter) == null) {
            this.actionManager.add(new ExportAction(this, aExporter.getName()));
        }
    }

    public void addMenu(final ComponentProvider aProvider) {
        SwingComponentUtils.invokeOnEDT((Runnable)new Runnable(){

            @Override
            public void run() {
                JMenuBar menuBar = ClientController.this.getMainMenuBar();
                if (menuBar != null) {
                    JMenu menu = (JMenu)aProvider.getComponent();
                    menuBar.add(menu);
                    aProvider.addedToContainer();
                    menuBar.revalidate();
                    menuBar.repaint();
                }
            }
        });
    }

    public void addTool(Tool<?> aTool) {
        if (this.tools.putIfAbsent(aTool.getName(), aTool) == null) {
            this.actionManager.add(new RunToolAction(this, aTool.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelCapture() {
        DataAcquisitionService acquisitionService = this.getDataAcquisitionService();
        Device device = this.getDevice();
        if (device == null || acquisitionService == null) {
            return;
        }
        try {
            acquisitionService.cancelAcquisition(device);
        }
        catch (IllegalStateException exception) {
            this.setStatusOnEDT("No acquisition in progress!", new Object[0]);
        }
        catch (IOException exception) {
            this.setStatusOnEDT("I/O problem: " + exception.getMessage(), new Object[0]);
            if (!HostUtils.handleInterruptedException((Throwable)exception)) {
                exception.printStackTrace();
            }
        }
        finally {
            this.updateActionsOnEDT();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean captureData(Window aParent) {
        DataAcquisitionService acquisitionService = this.getDataAcquisitionService();
        Device device = this.getDevice();
        if (device == null || acquisitionService == null) {
            return false;
        }
        try {
            if (device.setupCapture(aParent)) {
                this.setStatusOnEDT("Capture from {0} started at {1,date,medium} {1,time,medium} ...", device.getName(), new Date());
                acquisitionService.acquireData(device);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException exception) {
            this.setStatusOnEDT("I/O problem: " + exception.getMessage(), new Object[0]);
            if (!HostUtils.handleInterruptedException((Throwable)exception)) {
                exception.printStackTrace();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.updateActionsOnEDT();
        }
    }

    public void clearAnnotations() {
        for (Channel channel : this.getCurrentDataSet().getChannels()) {
            channel.clearAnnotations();
        }
        this.repaintMainFrame();
    }

    public void clearAnnotations(int aChannelIdx) {
        Channel channel = this.getChannel(aChannelIdx);
        channel.clearAnnotations();
        this.repaintMainFrame();
    }

    public void createNewProject() {
        this.projectManager.createNewProject();
        if (this.mainFrame != null) {
            this.mainFrame.repaint();
        }
        this.updateActionsOnEDT();
    }

    public void exit() {
        if (this.mainFrame != null) {
            this.mainFrame.setVisible(false);
            this.mainFrame.dispose();
            this.mainFrame = null;
        }
        try {
            this.bundleContext.getBundle(0L).stop(1);
        }
        catch (IllegalStateException ex) {
            LOG.warning("Bundle context no longer valid while shutting down client?!");
            System.exit(-1);
        }
        catch (BundleException be) {
            LOG.warning("Bundle context no longer valid while shutting down client?!");
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportTo(String aExporterName, File aExportFile) throws IOException {
        if (this.mainFrame == null) {
            return;
        }
        FileOutputStream writer = null;
        try {
            writer = new FileOutputStream(aExportFile);
            Exporter exporter = this.getExporter(aExporterName);
            exporter.export(this.getCurrentDataSet(), this.mainFrame.getDiagramScrollPane(), (OutputStream)writer);
            this.setStatusOnEDT("Export to {0} succesful ...", aExporterName);
        }
        catch (Throwable throwable) {
            HostUtils.closeResource(writer);
            this.updateActionsOnEDT();
            throw throwable;
        }
        HostUtils.closeResource((Closeable)writer);
        this.updateActionsOnEDT();
    }

    @Override
    public Action getAction(String aID) {
        return this.actionManager.getAction(aID);
    }

    public final Cursor getCursor(int aCursorIdx) {
        DataSet currentDataSet = this.getCurrentDataSet();
        if (currentDataSet == null) {
            return null;
        }
        return currentDataSet.getCursor(aCursorIdx);
    }

    public final Device getDevice() {
        String selectedDevice;
        if (this.mainFrame != null && (selectedDevice = this.mainFrame.getSelectedDeviceName()) != null) {
            return this.getDevice(selectedDevice);
        }
        return null;
    }

    public String[] getDeviceNames() {
        ArrayList result = new ArrayList(this.devices.keySet());
        Collections.sort(result);
        return result.toArray(new String[result.size()]);
    }

    public Exporter getExporter(String aName) throws IllegalArgumentException {
        return (Exporter)this.exporters.get(aName);
    }

    public String[] getExporterNames() {
        ArrayList result = new ArrayList(this.exporters.keySet());
        Collections.sort(result);
        return result.toArray(new String[result.size()]);
    }

    public String[] getExportExtensions(String aExporterName) {
        Exporter exporter = this.getExporter(aExporterName);
        if (exporter == null) {
            return new String[0];
        }
        return exporter.getFilenameExtentions();
    }

    public HostProperties getHostProperties() {
        return this.hostProperties;
    }

    public File getProjectFilename() {
        return this.getCurrentProject().getFilename();
    }

    public SignalDiagramController getSignalDiagramController() {
        return this.signalDiagramController;
    }

    public String[] getToolNames() {
        ArrayList result = new ArrayList(this.tools.keySet());
        Collections.sort(result);
        return result.toArray(new String[result.size()]);
    }

    public void gotoTriggerPosition() {
        AcquisitionResult capturedData = this.getCurrentDataSet().getCapturedData();
        if (capturedData != null && capturedData.hasTriggerData()) {
            long position = capturedData.getTriggerPosition();
            this.mainFrame.gotoPosition(0, position);
        }
    }

    public final boolean handleAbout() {
        this.showAboutBox();
        return true;
    }

    public final boolean handlePreferences() {
        this.showPreferencesDialog(this.getMainFrame());
        return true;
    }

    public final boolean handleQuit() {
        this.exit();
        return false;
    }

    public boolean hasCapturedData() {
        DataSet currentDataSet = this.getCurrentDataSet();
        return currentDataSet != null && currentDataSet.getCapturedData() != null;
    }

    public final boolean hasPreferences() {
        return true;
    }

    public void invokeTool(String aToolName, Window aParent) {
        Tool<?> tool;
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "Running tool: \"{0}\" ...", aToolName);
        }
        if ((tool = this.getTool(aToolName)) == null) {
            JOptionPane.showMessageDialog(aParent, "No such tool found: " + aToolName, "Error ...", 0);
        } else {
            ToolContext context = this.createToolContext();
            tool.invoke(aParent, context);
        }
        this.updateActionsOnEDT();
    }

    public boolean isDeviceSelected() {
        return this.mainFrame != null && this.mainFrame.getSelectedDeviceName() != null;
    }

    public boolean isDeviceSetup() {
        return this.isDeviceSelected() && this.getDevice().isSetup();
    }

    public boolean isProjectChanged() {
        Project currentProject = this.getCurrentProject();
        if (currentProject == null) {
            return false;
        }
        return currentProject.isChanged();
    }

    public void onAnnotation(Annotation<?> aAnnotation) {
        Channel channel = this.getChannel(aAnnotation.getChannel());
        channel.addAnnotation(aAnnotation);
        this.repaintAccumulatingRunnable.add(new Void[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openDataFile(File aFile) throws IOException {
        FileReader reader = new FileReader(aFile);
        try {
            this.getCurrentProject().readData((Reader)reader);
            this.setStatusOnEDT("Capture data loaded from {0} ...", aFile.getName());
        }
        finally {
            HostUtils.closeResource((Closeable)reader);
            this.updateActionsOnEDT();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openProjectFile(File aFile) throws IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(aFile);
            this.projectManager.loadProject((InputStream)fis);
            Project project = this.getCurrentProject();
            project.setFilename(aFile);
            this.setStatusOnEDT("Project {0} loaded ...", project.getName());
        }
        catch (Throwable throwable) {
            HostUtils.closeResource(fis);
            this.updateActionsOnEDT();
            throw throwable;
        }
        HostUtils.closeResource((Closeable)fis);
        this.updateActionsOnEDT();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDevice(Device aDevice) {
        ConcurrentMap<String, Device> concurrentMap = this.devices;
        synchronized (concurrentMap) {
            String deviceName = aDevice.getName();
            this.devices.remove(deviceName);
            try {
                IManagedAction action = this.actionManager.getAction(SelectDeviceAction.getID(deviceName));
                this.actionManager.remove(action);
            }
            catch (IllegalArgumentException exception) {
                LOG.log(Level.FINE, "No action for device {}?!", deviceName);
            }
        }
        this.updateActionsOnEDT();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExporter(Exporter aExporter) {
        ConcurrentMap<String, Exporter> concurrentMap = this.exporters;
        synchronized (concurrentMap) {
            String exporterName = aExporter.getName();
            this.exporters.remove(exporterName);
            try {
                IManagedAction action = this.actionManager.getAction(ExportAction.getID(exporterName));
                this.actionManager.remove(action);
            }
            catch (IllegalArgumentException exception) {
                LOG.log(Level.FINE, "No action for exporter {}?!", exporterName);
            }
        }
    }

    public void removeMenu(final ComponentProvider aProvider) {
        SwingComponentUtils.invokeOnEDT((Runnable)new Runnable(){

            @Override
            public void run() {
                JMenuBar menuBar = ClientController.this.getMainMenuBar();
                if (menuBar != null) {
                    aProvider.removedFromContainer();
                    menuBar.remove(aProvider.getComponent());
                    menuBar.revalidate();
                    menuBar.repaint();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTool(Tool<?> aTool) {
        ConcurrentMap<String, Tool<?>> concurrentMap = this.tools;
        synchronized (concurrentMap) {
            String toolName = aTool.getName();
            this.tools.remove(toolName);
            try {
                IManagedAction action = this.actionManager.getAction(RunToolAction.getID(toolName));
                this.actionManager.remove(action);
            }
            catch (IllegalArgumentException exception) {
                LOG.log(Level.FINE, "No action for tool {}?!", toolName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repeatCaptureData() {
        DataAcquisitionService acquisitionService = this.getDataAcquisitionService();
        Device devCtrl = this.getDevice();
        if (devCtrl == null || acquisitionService == null) {
            return;
        }
        try {
            this.setStatusOnEDT("Capture from {0} started at {1,date,medium} {1,time,medium} ...", devCtrl.getName(), new Date());
            acquisitionService.acquireData(devCtrl);
        }
        catch (IOException exception) {
            this.setStatusOnEDT("I/O problem: " + exception.getMessage(), new Object[0]);
            exception.printStackTrace();
            HostUtils.handleInterruptedException((Throwable)exception);
        }
        finally {
            this.updateActionsOnEDT();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDataFile(File aFile) throws IOException {
        FileWriter writer = new FileWriter(aFile);
        try {
            this.getCurrentProject().writeData((Writer)writer);
            this.setStatusOnEDT("Capture data saved to {0} ...", aFile.getName());
        }
        finally {
            HostUtils.closeResource((Closeable)writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveProjectFile(String aName, File aFile) throws IOException {
        FileOutputStream out = null;
        try {
            Project project = this.getCurrentProject();
            project.setFilename(aFile);
            project.setName(aName);
            out = new FileOutputStream(aFile);
            this.projectManager.saveProject((OutputStream)out);
            this.setStatusOnEDT("Project {0} saved ...", aName);
        }
        catch (Throwable throwable) {
            HostUtils.closeResource(out);
            throw throwable;
        }
        HostUtils.closeResource((Closeable)out);
    }

    public void selectDevice(String aDeviceName) {
        if (this.mainFrame != null) {
            this.mainFrame.setSelectedDeviceName(aDeviceName);
        }
        this.updateActionsOnEDT();
    }

    public void showAboutBox() {
        if (this.mainFrame != null) {
            this.mainFrame.showAboutBox();
        }
    }

    public void showBundlesDialog(Window aOwner) {
        BundlesDialog dialog = new BundlesDialog(aOwner, this.bundleContext);
        if (dialog.showDialog()) {
            dialog.dispose();
        }
    }

    public void showPreferencesDialog(Window aParent) {
        final PreferencesDialog dialog = new PreferencesDialog(aParent, this.colorSchemeManager);
        final DependencyManager dm = new DependencyManager(this.bundleContext);
        final Component comp = dm.createComponent();
        comp.setImplementation((Object)dialog).add((Dependency)dm.createServiceDependency().setService(ConfigurationAdmin.class).setInstanceBound(true).setRequired(true)).addStateListener((ComponentStateListener)new ComponentStateAdapter(){

            @Override
            public void started(Component aComponent) {
                if (dialog.showDialog()) {
                    ClientController.this.repaintMainFrame();
                }
                dm.remove(comp);
            }
        });
        dm.add(comp);
    }

    public final void start() {
        final HostProperties hostProperties = this.getHostProperties();
        this.initOSSpecifics(hostProperties.getShortName());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JErrorDialog.installSwingExceptionHandler();
                File dataStorage = ClientController.this.bundleContext.getDataFile("");
                MainFrame mf = new MainFrame(new DockController(dataStorage, ClientController.this.getSignalDiagramController()), ClientController.this);
                ClientController.this.setMainFrame(mf);
                ClientController.this.signalDiagramController.addCursorChangeListener(new CursorActionListener());
                ClientController.this.signalDiagramController.setDefaultSettings();
                mf.setTitle(hostProperties.getFullName());
                mf.setStatus("{0} v{1} ready ...", hostProperties.getShortName(), hostProperties.getVersion());
                mf.setVisible(true);
                LOG.info("Client started ...");
            }
        });
    }

    public final void stop() {
        this.devices.clear();
        this.tools.clear();
        this.exporters.clear();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame mf = ClientController.this.getMainFrame();
                if (mf != null) {
                    Window[] openWindows;
                    for (Window window : openWindows = Window.getWindows()) {
                        LOG.log(Level.FINE, "(Forced) closing window {0} ...", window);
                        window.setVisible(false);
                        window.dispose();
                    }
                    mf.close();
                    ClientController.this.removeMainFrame(mf);
                }
                JErrorDialog.uninstallSwingExceptionHandler();
                LOG.info("Client stopped ...");
            }
        });
    }

    final DataSet getCurrentDataSet() {
        Project currentProject = this.getCurrentProject();
        if (currentProject == null) {
            return null;
        }
        return currentProject.getDataSet();
    }

    final Project getCurrentProject() {
        if (this.projectManager == null) {
            return null;
        }
        return this.projectManager.getCurrentProject();
    }

    final MainFrame getMainFrame() {
        return this.mainFrame;
    }

    final JMenuBar getMainMenuBar() {
        JMenuBar result = null;
        if (this.mainFrame != null) {
            result = this.mainFrame.getJMenuBar();
        }
        return result;
    }

    final void removeMainFrame(MainFrame aMainFrame) {
        if (this.projectManager != null) {
            this.projectManager.removePropertyChangeListener((PropertyChangeListener)aMainFrame);
        }
        this.mainFrame = null;
    }

    final void removeProjectManager(ProjectManager aProjectManager) {
        if (this.signalDiagramController != null) {
            aProjectManager.removePropertyChangeListener((PropertyChangeListener)this.signalDiagramController);
        }
        if (this.mainFrame != null) {
            aProjectManager.removePropertyChangeListener((PropertyChangeListener)this.mainFrame);
        }
        this.projectManager = null;
    }

    final void setMainFrame(MainFrame aMainFrame) {
        this.mainFrame = aMainFrame;
        if (this.projectManager != null) {
            this.projectManager.addPropertyChangeListener((PropertyChangeListener)this.mainFrame);
        }
    }

    final void setProgressOnEDT(final int aPercentage) {
        if (this.mainFrame != null) {
            SwingComponentUtils.invokeOnEDT((Runnable)new Runnable(){

                @Override
                public void run() {
                    ClientController.this.mainFrame.setProgress(aPercentage);
                }
            });
        }
    }

    final void setProjectManager(ProjectManager aProjectManager) {
        this.projectManager = aProjectManager;
        if (this.projectManager != null) {
            if (this.signalDiagramController != null) {
                this.projectManager.addPropertyChangeListener((PropertyChangeListener)this.signalDiagramController);
            }
            if (this.mainFrame != null) {
                this.projectManager.addPropertyChangeListener((PropertyChangeListener)this.mainFrame);
            }
        }
    }

    void setStatusOnEDT(final String aMessage, final Object ... aMessageArgs) {
        if (this.mainFrame != null) {
            SwingComponentUtils.invokeOnEDT((Runnable)new Runnable(){

                @Override
                public void run() {
                    ClientController.this.mainFrame.setStatus(aMessage, aMessageArgs);
                }
            });
        }
    }

    final void updateActionsOnEDT() {
        SwingComponentUtils.invokeOnEDT((Runnable)new Runnable(){

            @Override
            public void run() {
                IManagedAction[] exportActions;
                IManagedAction[] toolActions;
                DataAcquisitionService acquisitionService = ClientController.this.getDataAcquisitionService();
                Device device = ClientController.this.getDevice();
                boolean deviceControllerSet = device != null;
                boolean deviceCapturing = acquisitionService != null && acquisitionService.isAcquiring();
                boolean deviceSetup = deviceControllerSet && !deviceCapturing && device.isSetup();
                ClientController.this.getAction("Capture").setEnabled(deviceControllerSet);
                ClientController.this.getAction("CancelCapture").setEnabled(deviceCapturing);
                ClientController.this.getAction("RepeatCapture").setEnabled(deviceSetup);
                boolean projectChanged = ClientController.this.isProjectChanged();
                boolean projectSavedBefore = !ClientController.this.isAnonymousProject();
                boolean dataAvailable = ClientController.this.hasCapturedData();
                boolean hasTriggerData = ClientController.this.hasTriggerData();
                boolean cursorsEnabled = ClientController.this.areCursorsEnabled();
                boolean enableCursors = dataAvailable && cursorsEnabled;
                ClientController.this.getAction("SaveProject").setEnabled(projectChanged);
                ClientController.this.getAction("SaveProjectAs").setEnabled(projectSavedBefore && projectChanged);
                ClientController.this.getAction("SaveDataFile").setEnabled(dataAvailable);
                ClientController.this.getAction("GotoTrigger").setEnabled(dataAvailable && hasTriggerData);
                ClientController.this.getAction("SetCursorMode").setEnabled(dataAvailable);
                ClientController.this.getAction("SetCursorMode").putValue("SwingSelectedKey", cursorsEnabled);
                ClientController.this.getAction(SmartJumpAction.getJumpLeftID()).setEnabled(dataAvailable);
                ClientController.this.getAction(SmartJumpAction.getJumpRightID()).setEnabled(dataAvailable);
                boolean anyCursorSet = false;
                for (int c = 0; c < 10; ++c) {
                    boolean cursorPositionSet = ClientController.this.isCursorSet(c);
                    anyCursorSet |= cursorPositionSet;
                    boolean gotoCursorNEnabled = enableCursors && cursorPositionSet;
                    ClientController.this.getAction(GotoNthCursorAction.getID(c)).setEnabled(gotoCursorNEnabled);
                }
                boolean snapCursorMode = ClientController.this.getSignalDiagramController().getSignalDiagramModel().isSnapCursorMode();
                ClientController.this.getAction("SnapCursors").putValue("SwingSelectedKey", snapCursorMode);
                ClientController.this.getAction("GotoFirstCursor").setEnabled(enableCursors && anyCursorSet);
                ClientController.this.getAction("GotoLastCursor").setEnabled(enableCursors && anyCursorSet);
                ClientController.this.getAction("DeleteAllCursors").setEnabled(enableCursors && anyCursorSet);
                ClientController.this.getAction("RemoveAnnotations").setEnabled(dataAvailable);
                ClientController.this.getAction("SetMeasurementMode").setEnabled(dataAvailable);
                for (IManagedAction toolAction : toolActions = ClientController.this.getActionsByType(RunToolAction.class)) {
                    toolAction.setEnabled(dataAvailable);
                }
                for (IManagedAction exportAction : exportActions = ClientController.this.getActionsByType(ExportAction.class)) {
                    exportAction.setEnabled(dataAvailable);
                }
            }
        });
    }

    protected boolean areCursorsEnabled() {
        return this.signalDiagramController.getSignalDiagramModel().isCursorMode();
    }

    protected IManagedAction[] getActionsByType(Class<? extends IManagedAction> aActionType) {
        if (this.actionManager == null) {
            return new IManagedAction[0];
        }
        return this.actionManager.getActionByType(aActionType);
    }

    protected boolean hasTriggerData() {
        DataSet currentDataSet = this.getCurrentDataSet();
        if (currentDataSet == null || currentDataSet.getCapturedData() == null) {
            return false;
        }
        return currentDataSet.getCapturedData().hasTriggerData();
    }

    protected boolean isAnonymousProject() {
        Project currentProject = this.getCurrentProject();
        if (currentProject == null) {
            return false;
        }
        return currentProject.getFilename() == null;
    }

    protected boolean isCursorSet(int aCursorIdx) {
        Cursor cursor = this.getCursor(aCursorIdx);
        if (cursor == null) {
            return false;
        }
        return cursor.isDefined();
    }

    private ToolContext createToolContext() {
        int enabledChannels;
        int channels;
        int startOfDecode = -1;
        int endOfDecode = -1;
        DataSet dataSet = this.getCurrentDataSet();
        AcquisitionResult capturedData = dataSet.getCapturedData();
        int dataLength = capturedData.getValues().length;
        if (this.areCursorsEnabled()) {
            if (this.isCursorSet(0)) {
                Cursor cursor1 = dataSet.getCursor(0);
                startOfDecode = capturedData.getSampleIndex(cursor1.getTimestamp()) - 1;
            }
            if (this.isCursorSet(1)) {
                Cursor cursor2 = dataSet.getCursor(1);
                endOfDecode = capturedData.getSampleIndex(cursor2.getTimestamp()) + 1;
            }
        } else {
            startOfDecode = 0;
            endOfDecode = dataLength;
        }
        startOfDecode = Math.max(0, startOfDecode);
        if (endOfDecode < 0 || endOfDecode >= dataLength) {
            endOfDecode = dataLength - 1;
        }
        if ((channels = capturedData.getChannels()) == -1) {
            channels = 32;
        }
        if ((enabledChannels = capturedData.getEnabledChannels()) == -1) {
            enabledChannels = NumberUtils.getBitMask((int)channels);
        }
        return new DefaultToolContext(startOfDecode, endOfDecode, dataSet);
    }

    private Channel getChannel(int aChannelIdx) {
        DataSet currentDataSet = this.getCurrentDataSet();
        if (currentDataSet == null) {
            return null;
        }
        return currentDataSet.getChannel(aChannelIdx);
    }

    private DataAcquisitionService getDataAcquisitionService() {
        return this.dataAcquisitionService;
    }

    private Device getDevice(String aName) throws IllegalArgumentException {
        return (Device)this.devices.get(aName);
    }

    private Tool<?> getTool(String aName) throws IllegalArgumentException {
        return (Tool)this.tools.get(aName);
    }

    private void initOSSpecifics(String aApplicationName) {
        HostInfo hostInfo = HostUtils.getHostInfo();
        if (hostInfo.isMacOS()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("apple.awt.graphics.EnableQ2DX", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", aApplicationName);
            System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
            System.setProperty("com.apple.mrj.application.live-resize", "false");
            System.setProperty("com.apple.macos.smallTabs", "true");
            System.setProperty("apple.eawt.quitStrategy", "CLOSE_ALL_WINDOWS");
            ActionMap map = (ActionMap)UIManager.get("OptionPane.actionMap");
            if (map == null) {
                map = new ActionMap();
                UIManager.put("OptionPane.actionMap", map);
            }
            map.put("close", new CloseOptionPaneAction());
            UIManager.put("OptionPane.windowBindings", new Object[]{SwingComponentUtils.createMenuKeyMask((int)87, (int[])new int[0]), "close", "ESCAPE", "close"});
        } else if (hostInfo.isUnix()) {
            UIManager.put("Application.useSystemFontSettings", Boolean.FALSE);
            this.setLookAndFeel("com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
        } else if (hostInfo.isWindows()) {
            UIManager.put("Application.useSystemFontSettings", Boolean.TRUE);
            this.setLookAndFeel("com.jgoodies.looks.plastic.PlasticXPLookAndFeel");
        }
    }

    private void repaintMainFrame() {
        if (this.mainFrame != null) {
            SwingComponentUtils.invokeOnEDT((Runnable)new Runnable(){

                @Override
                public void run() {
                    ClientController.this.mainFrame.repaint();
                }
            });
        }
    }

    private void setLookAndFeel(String aLookAndFeelClassName) {
        block2: {
            UIDefaults defaults = UIManager.getLookAndFeelDefaults();
            defaults.put("ClassLoader", Activator.class.getClassLoader());
            try {
                UIManager.setLookAndFeel(aLookAndFeelClassName);
            }
            catch (Exception exception) {
                if (HostUtils.handleInterruptedException((Throwable)exception)) break block2;
                System.err.println("Failed to set look and feel to: " + aLookAndFeelClassName);
                this.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
    }

    final class ProgressUpdatingRunnable
    extends AccumulatingRunnable<Integer> {
        ProgressUpdatingRunnable() {
        }

        protected void run(Deque<Integer> aArgs) {
            Integer percentage = aArgs.getLast();
            ClientController.this.setProgressOnEDT(percentage);
            ClientController.this.updateActionsOnEDT();
        }
    }

    static final class DefaultToolContext
    implements ToolContext {
        private final DataSet dataSet;
        private final int startSampleIdx;
        private final int endSampleIdx;

        public DefaultToolContext(int aStartSampleIdx, int aEndSampleIdx, DataSet aDataSet) {
            this.startSampleIdx = aStartSampleIdx;
            this.endSampleIdx = aEndSampleIdx;
            this.dataSet = aDataSet;
        }

        public int getChannels() {
            return this.getData().getChannels();
        }

        public Cursor getCursor(int aIndex) {
            return this.dataSet.getCursor(aIndex);
        }

        public AcquisitionResult getData() {
            return this.dataSet.getCapturedData();
        }

        public int getEnabledChannels() {
            return this.getData().getEnabledChannels();
        }

        public int getEndSampleIndex() {
            return this.endSampleIdx;
        }

        public int getLength() {
            return Math.max(0, this.endSampleIdx - this.startSampleIdx);
        }

        public int getStartSampleIndex() {
            return this.startSampleIdx;
        }
    }

    final class CursorActionListener
    implements ICursorChangeListener {
        CursorActionListener() {
        }

        @Override
        public void cursorAdded(Cursor aCursor) {
            ClientController.this.updateActionsOnEDT();
        }

        @Override
        public void cursorChanged(String aPropertyName, Cursor aOldCursor, Cursor aNewCursor) {
        }

        @Override
        public void cursorRemoved(Cursor aOldCursor) {
            ClientController.this.updateActionsOnEDT();
        }

        @Override
        public void cursorsInvisible() {
            ClientController.this.updateActionsOnEDT();
        }

        @Override
        public void cursorsVisible() {
            ClientController.this.updateActionsOnEDT();
        }
    }

    static final class CloseOptionPaneAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        CloseOptionPaneAction() {
        }

        @Override
        public void actionPerformed(ActionEvent aEvent) {
            JOptionPane optionPane = (JOptionPane)aEvent.getSource();
            optionPane.setValue(-1);
        }
    }

    final class AccumulatingRepaintingRunnable
    extends AccumulatingRunnable<Void> {
        AccumulatingRepaintingRunnable() {
        }

        protected void run(Deque<Void> aArgs) {
            ClientController.this.repaintMainFrame();
        }
    }
}

