/*
 * Decompiled with CFR 0.152.
 */
package org.sump.device.logicsniffer.protocol;

import java.io.DataOutputStream;
import java.io.IOException;
import org.sump.device.logicsniffer.LogicSnifferConfig;
import org.sump.device.logicsniffer.protocol.SumpCommandWriter;

public class DemonCoreCommandWriter
extends SumpCommandWriter {
    public static final int RANGE_XOR0 = 43690;
    public static final int RANGE_XOR1 = 21845;
    public static final int RANGE_NOP = 65535;
    public static final int EDGE_RISE0 = 2570;
    public static final int EDGE_RISE1 = 204;
    public static final int EDGE_FALL0 = 20560;
    public static final int EDGE_FALL1 = 13056;
    public static final int EDGE_BOTH0 = 23130;
    public static final int EDGE_BOTH1 = 13260;
    public static final int EDGE_NEITHER0 = 42405;
    public static final int EDGE_NEITHER1 = 52275;
    public static final int TRIGSTATE_STATENUM_MASK = 15;
    public static final int TRIGSTATE_OBTAIN_MASK = 1048575;
    public static final int TRIGSTATE_ELSE_BITOFS = 20;
    public static final long TRIGSTATE_STOP_TIMER0 = 0x1000000L;
    public static final long TRIGSTATE_STOP_TIMER1 = 0x2000000L;
    public static final long TRIGSTATE_CLEAR_TIMER0 = 0x4000000L;
    public static final long TRIGSTATE_CLEAR_TIMER1 = 0x8000000L;
    public static final long TRIGSTATE_START_TIMER0 = 0x10000000L;
    public static final long TRIGSTATE_START_TIMER1 = 0x20000000L;
    public static final long TRIGSTATE_TRIGGER_FLAG = 0x40000000L;
    public static final long TRIGSTATE_LASTSTATE = 0x80000000L;
    public static final int OP_NOP = 0;
    public static final int OP_ANY = 1;
    public static final int OP_AND = 2;
    public static final int OP_NAND = 3;
    public static final int OP_OR = 4;
    public static final int OP_NOR = 5;
    public static final int OP_XOR = 6;
    public static final int OP_NXOR = 7;
    public static final int OP_A = 8;
    public static final int OP_B = 9;
    private static final int CMD_SELECT = 158;
    private static final int CMD_CHAIN = 159;

    public DemonCoreCommandWriter(LogicSnifferConfig aConfiguration, DataOutputStream aOutputStream) {
        super(aConfiguration, aOutputStream);
    }

    public void writeEdge(TriggerEdge aEdge, int aRisingEdge, int aFallingEdge, int aNeitherEdge) throws IOException {
        this.writeSelect(aEdge.getLutChainAddress());
        int lutvalue = 0;
        long bitmask = 0x80000000L;
        for (int i = 0; i < 16; ++i) {
            if (aNeitherEdge != 0 && bitmask != 0L) {
                lutvalue |= 0xCC33;
            } else {
                if (((long)aRisingEdge & bitmask) != 0L) {
                    lutvalue |= 0xCC;
                }
                if (((long)aFallingEdge & bitmask) != 0L) {
                    lutvalue |= 0x3300;
                }
            }
            if (aNeitherEdge != 0 && (bitmask >>>= 1) != 0L) {
                lutvalue |= 0xA5A5;
            } else {
                if (((long)aRisingEdge & bitmask) != 0L) {
                    lutvalue |= 0xA0A;
                }
                if (((long)aFallingEdge & bitmask) != 0L) {
                    lutvalue |= 0x5050;
                }
            }
            bitmask >>>= 1;
            if ((i & 1) == 0) {
                lutvalue <<= 16;
                continue;
            }
            this.writeChain(lutvalue);
            lutvalue = 0;
        }
    }

    public void writeRange(TriggerRange aRange, int aTarget, int aMask) throws IOException {
        int lutValue = 0;
        this.writeSelect(aRange.getLutChainAddress());
        int bitcount = Integer.bitCount(aMask);
        long value = aRange.isLowerRange() ? (long)(~(aTarget - 1) & 0xFFFFFFFF) : (long)(~aTarget & 0xFFFFFFFF);
        value <<= 32 - bitcount & 0xFFFFFFFF;
        for (int i = 0; i < 16; ++i) {
            if ((aMask >>> 31 & 1) == 0) {
                lutValue = 65535;
            } else {
                lutValue = (value >>> 31 & 1L) != 0L ? 21845 : 43690;
                value <<= 1;
            }
            lutValue <<= 16;
            if (((aMask <<= 1) >>> 31 & 1) == 0) {
                lutValue |= 0xFFFF;
            } else {
                lutValue |= (value >>> 31 & 1L) != 0L ? 21845 : 43690;
                value <<= 1;
            }
            aMask <<= 1;
            this.writeChain(lutValue);
        }
    }

    public void writeTerm(TriggerTerm aTerm, int aTarget, int aMask) throws IOException {
        int bitmask = 1;
        int lutvalue0 = 0;
        int lutvalue1 = 0;
        int lutvalue2 = 0;
        int lutvalue3 = 0;
        for (int i = 0; i < 16; ++i) {
            if (((i ^ aTarget & 0xF) & (aMask & 0xF)) == 0) {
                lutvalue0 |= bitmask;
            }
            if (((i ^ aTarget >>> 4 & 0xF) & (aMask >>> 4 & 0xF)) == 0) {
                lutvalue0 |= bitmask << 16;
            }
            if (((i ^ aTarget >>> 8 & 0xF) & (aMask >>> 8 & 0xF)) == 0) {
                lutvalue1 |= bitmask;
            }
            if (((i ^ aTarget >>> 12 & 0xF) & (aMask >>> 12 & 0xF)) == 0) {
                lutvalue1 |= bitmask << 16;
            }
            if (((i ^ aTarget >>> 16 & 0xF) & (aMask >>> 16 & 0xF)) == 0) {
                lutvalue2 |= bitmask;
            }
            if (((i ^ aTarget >>> 20 & 0xF) & (aMask >>> 20 & 0xF)) == 0) {
                lutvalue2 |= bitmask << 16;
            }
            if (((i ^ aTarget >>> 24 & 0xF) & (aMask >>> 24 & 0xF)) == 0) {
                lutvalue3 |= bitmask;
            }
            if (((i ^ aTarget >>> 28 & 0xF) & (aMask >>> 28 & 0xF)) == 0) {
                lutvalue3 |= bitmask << 16;
            }
            bitmask <<= 1;
        }
        this.writeSelect(aTerm.getLutChainAddress());
        this.writeChain(lutvalue3);
        this.writeChain(lutvalue2);
        this.writeChain(lutvalue1);
        this.writeChain(lutvalue0);
    }

    public void writeTriggerLimit(TriggerTimer aTimer, long aValue) throws IOException {
        this.writeSelect(aTimer.getLutChainAddress());
        this.writeChain((int)(aValue & 0xFFFFFFFFFFFFFFFFL));
        this.writeSelect(aTimer.getLutChainAddress() + 1);
        this.writeChain((int)(aValue >>> 32 & 0xFL));
    }

    public void writeTriggerState(int aStateNumber, boolean aLastState, boolean aSetTrigger, int aStartTimer, int aStopTimer, int aClearTimer, int aElseState, int aOccurrenceCount) throws IOException {
        this.writeSelect(aStateNumber & 0xF);
        int value = (aElseState & 0xF) << 20 | aOccurrenceCount & 0xFFFFF;
        if (aLastState) {
            value = (int)((long)value | 0x80000000L);
        }
        if (aSetTrigger) {
            value = (int)((long)value | 0x40000000L);
        }
        if ((aStartTimer & 1) != 0) {
            value = (int)((long)value | 0x10000000L);
        }
        if ((aStartTimer & 2) != 0) {
            value = (int)((long)value | 0x20000000L);
        }
        if ((aStopTimer & 1) != 0) {
            value = (int)((long)value | 0x1000000L);
        }
        if ((aStopTimer & 2) != 0) {
            value = (int)((long)value | 0x2000000L);
        }
        if ((aClearTimer & 1) != 0) {
            value = (int)((long)value | 0x4000000L);
        }
        if ((aClearTimer & 2) != 0) {
            value = (int)((long)value | 0x8000000L);
        }
        this.writeChain(value);
    }

    public void writeTriggerSum(int aStateNumber, int aStateTerm, int op_ab, int op_c_range1, int op_d_edge1, int op_e_timer1, int op_fg, int op_h_range2, int op_i_edge2, int op_j_timer2, int op_mid1, int op_mid2, int op_final) throws IOException {
        int[] pairvalue = new int[]{0, 65535, 32768, Short.MAX_VALUE, 63624, 1911, 30856, 34679, 34952, 61440};
        int[] midvalue = new int[]{0, 65535, 32768, Short.MAX_VALUE, 65534, 1, 278, 65257, 61166, 65520};
        int[] finalvalue = new int[]{0, 65535, 8, 7, 14, 1, 6, 9, 2, 4};
        this.writeSelect(64 + aStateNumber * 4 + aStateTerm);
        this.writeChain(finalvalue[op_final]);
        this.writeChain(midvalue[op_mid2] << 16 | midvalue[op_mid1]);
        this.writeChain(pairvalue[op_j_timer2] << 16 | pairvalue[op_i_edge2]);
        this.writeChain(pairvalue[op_h_range2] << 16 | pairvalue[op_fg]);
        this.writeChain(pairvalue[op_e_timer1] << 16 | pairvalue[op_d_edge1]);
        this.writeChain(pairvalue[op_c_range1] << 16 | pairvalue[op_ab]);
    }

    private void writeChain(int aValue) throws IOException {
        this.sendCommand(159, aValue);
    }

    private void writeSelect(int aValue) throws IOException {
        this.sendCommand(158, aValue);
    }

    public static enum TriggerTimer {
        TIMER_1(56),
        TIMER_2(58);

        private final int lutChainAddress;

        private TriggerTimer(int aLutChainAddress) {
            this.lutChainAddress = aLutChainAddress;
        }

        public int getLutChainAddress() {
            return this.lutChainAddress;
        }
    }

    public static enum TriggerTerm {
        TERM_A(32),
        TERM_B(33),
        TERM_C(34),
        TERM_D(35),
        TERM_E(36),
        TERM_F(37),
        TERM_G(38),
        TERM_H(39),
        TERM_I(40),
        TERM_J(41);

        private final int lutChainAddress;

        private TriggerTerm(int aLutChainAddress) {
            this.lutChainAddress = aLutChainAddress;
        }

        public int getLutChainAddress() {
            return this.lutChainAddress;
        }
    }

    public static enum TriggerRange {
        RANGE_1_LOWER(48),
        RANGE_1_UPPER(49),
        RANGE_2_LOWER(50),
        RANGE_2_UPPER(51);

        private final int lutChainAddress;

        private TriggerRange(int aLutChainAddress) {
            this.lutChainAddress = aLutChainAddress;
        }

        public int getLutChainAddress() {
            return this.lutChainAddress;
        }

        public boolean isLowerRange() {
            return this == RANGE_1_LOWER || this == RANGE_2_LOWER;
        }
    }

    public static enum TriggerEdge {
        EDGE_1(52),
        EDGE_2(53);

        private final int lutChainAddress;

        private TriggerEdge(int aLutChainAddress) {
            this.lutChainAddress = aLutChainAddress;
        }

        public int getLutChainAddress() {
            return this.lutChainAddress;
        }
    }
}

