/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay.view;

import java.awt.Point;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import nl.lxtreme.ols.api.data.Cursor;
import nl.lxtreme.ols.client.actionmanager.IActionManager;
import nl.lxtreme.ols.client.signaldisplay.MeasurementInfo;
import nl.lxtreme.ols.client.signaldisplay.SignalDiagramController;
import nl.lxtreme.ols.client.signaldisplay.action.DeleteCursorAction;
import nl.lxtreme.ols.client.signaldisplay.action.EditCursorPropertiesAction;
import nl.lxtreme.ols.client.signaldisplay.action.EditSignalElementPropertiesAction;
import nl.lxtreme.ols.client.signaldisplay.action.RemoveChannelAnnotations;
import nl.lxtreme.ols.client.signaldisplay.action.SetCursorAction;
import nl.lxtreme.ols.client.signaldisplay.action.SetSignalElementVisibilityAction;
import nl.lxtreme.ols.client.signaldisplay.action.SetSignalGroupVisibilityAction;
import nl.lxtreme.ols.client.signaldisplay.model.SignalDiagramModel;
import nl.lxtreme.ols.client.signaldisplay.signalelement.SignalElement;

final class PopupFactory {
    private final SignalDiagramController controller;

    PopupFactory(SignalDiagramController aController) {
        this.controller = aController;
    }

    public JPopupMenu createChannelLabelPopup(Point aRelativePoint, Point aLocationOnScreen) {
        return this.createPopup(aRelativePoint, aLocationOnScreen, null, false);
    }

    public JPopupMenu createCursorPopup(Cursor aHoveredCursor, Point aPoint, Point aLocationOnScreen) {
        return this.createPopup(aPoint, aLocationOnScreen, aHoveredCursor, true);
    }

    private void addCursorActions(JPopupMenu aMenu, Cursor aHoveredCursor, Point aPoint) {
        Cursor cursor = aHoveredCursor;
        if (cursor != null) {
            aMenu.add(new EditCursorPropertiesAction(this.controller, cursor));
            aMenu.addSeparator();
            aMenu.add(new DeleteCursorAction(this.controller, cursor));
        } else {
            for (int i = 0; i < 10; ++i) {
                SetCursorAction action = new SetCursorAction(this.controller, i);
                aMenu.add(new JCheckBoxMenuItem(action));
            }
            aMenu.putClientProperty("SetCursorAction", this.getCursorDropPoint(aPoint));
        }
    }

    private JPopupMenu createPopup(Point aPoint, Point aLocationOnScreen, Cursor aHoveredCursor, boolean aShowCursorSection) {
        IActionManager actionMgr = this.controller.getActionManager();
        JPopupMenu contextMenu = new JPopupMenu();
        contextMenu.putClientProperty("mouseLocation", aPoint);
        boolean elementAdded = false;
        if (aHoveredCursor == null) {
            SignalElement signalElement = this.findSignalElement(aPoint);
            if (signalElement == null) {
                return null;
            }
            if (signalElement.isSignalGroup()) {
                contextMenu.add(new SetSignalGroupVisibilityAction(this.controller, signalElement, SignalElement.SignalElementType.DIGITAL_SIGNAL));
                contextMenu.add(new SetSignalGroupVisibilityAction(this.controller, signalElement, SignalElement.SignalElementType.GROUP_SUMMARY));
                contextMenu.add(new SetSignalGroupVisibilityAction(this.controller, signalElement, SignalElement.SignalElementType.ANALOG_SIGNAL));
            } else {
                contextMenu.add(new EditSignalElementPropertiesAction(this.controller, signalElement, aLocationOnScreen));
                contextMenu.addSeparator();
                contextMenu.add(new SetSignalElementVisibilityAction(this.controller, signalElement));
            }
            if (signalElement.isDigitalSignal()) {
                contextMenu.add(new RemoveChannelAnnotations(this.controller, signalElement));
            }
            elementAdded = true;
        }
        if (aShowCursorSection) {
            if (elementAdded) {
                contextMenu.addSeparator();
            }
            this.addCursorActions(contextMenu, aHoveredCursor, aPoint);
        }
        contextMenu.addSeparator();
        contextMenu.add(actionMgr.getAction("DeleteAllCursors"));
        return contextMenu;
    }

    private SignalElement findSignalElement(Point aPoint) {
        return this.getModel().findSignalElement(aPoint);
    }

    private Point getCursorDropPoint(Point aCoordinate) {
        MeasurementInfo signalHover;
        Point dropPoint = new Point(aCoordinate);
        if (this.getModel().isSnapCursorMode() && (signalHover = this.getModel().getSignalHover(aCoordinate)) != null && !signalHover.isEmpty()) {
            dropPoint.x = signalHover.getMidSamplePos();
        }
        dropPoint.y = 0;
        return dropPoint;
    }

    private SignalDiagramModel getModel() {
        return this.controller.getSignalDiagramModel();
    }
}

