/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.action;

import java.awt.AWTEvent;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.filechooser.FileFilter;
import nl.lxtreme.ols.client.ClientController;
import nl.lxtreme.ols.client.action.BaseAction;
import nl.lxtreme.ols.client.action.OpenDataFileAction;
import nl.lxtreme.ols.util.HostUtils;
import nl.lxtreme.ols.util.swing.SwingComponentUtils;
import nl.lxtreme.ols.util.swing.component.JErrorDialog;

public class SaveDataFileAction
extends BaseAction {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(SaveDataFileAction.class.getName());
    public static final String ID = "SaveDataFile";

    public SaveDataFileAction(ClientController aController) {
        super(ID, aController, "document-save.png", "Save ...", "Save data file");
        this.putValue("MnemonicKey", 83);
    }

    @Override
    public void actionPerformed(ActionEvent aEvent) {
        block3: {
            Window owner = SwingComponentUtils.getOwningWindow((AWTEvent)aEvent);
            File file = SwingComponentUtils.showFileSaveDialog((Window)owner, (FileFilter[])new FileFilter[]{OpenDataFileAction.OLS_FILEFILTER});
            if (file != null) {
                File actualFile = HostUtils.setFileExtension((File)file, (String)"ols");
                LOG.log(Level.INFO, "Saving capture data to file {0}", actualFile);
                try {
                    this.getController().saveDataFile(actualFile);
                }
                catch (IOException exception) {
                    if (HostUtils.handleInterruptedException((Throwable)exception)) break block3;
                    LOG.log(Level.WARNING, "Saving capture data failed!", exception);
                    JErrorDialog.showDialog((Window)owner, (String)"Saving the capture data failed!", (Throwable)exception);
                }
            }
        }
    }
}

