/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.tool.i2c;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.lxtreme.ols.api.acquisition.AcquisitionResult;
import nl.lxtreme.ols.api.data.annotation.Annotation;
import nl.lxtreme.ols.api.data.annotation.AnnotationListener;
import nl.lxtreme.ols.api.tools.ToolContext;
import nl.lxtreme.ols.api.tools.ToolProgressListener;
import nl.lxtreme.ols.api.tools.ToolTask;
import nl.lxtreme.ols.tool.base.annotation.ChannelLabelAnnotation;
import nl.lxtreme.ols.tool.base.annotation.SampleDataAnnotation;
import nl.lxtreme.ols.tool.i2c.I2CDataSet;
import nl.lxtreme.ols.util.NumberUtils;

public class I2CAnalyserTask
implements ToolTask<I2CDataSet> {
    public static final String LINE_A = "LineA";
    public static final String LINE_B = "LineB";
    public static final String PROPERTY_AUTO_DETECT_SCL = "AutoDetectSCL";
    public static final String PROPERTY_AUTO_DETECT_SDA = "AutoDetectSDA";
    private static final String CHANNEL_SCL_NAME = "SCL";
    private static final String CHANNEL_SDA_NAME = "SDA";
    private static final int I2C_BITCOUNT = 8;
    private static final Logger LOG = Logger.getLogger(I2CAnalyserTask.class.getName());
    private final ToolContext context;
    private final ToolProgressListener progressListener;
    private final AnnotationListener annotationListener;
    private final PropertyChangeSupport pcs;
    private boolean detectSDA_SCL;
    private boolean reportACK;
    private boolean reportNACK;
    private boolean reportStart;
    private boolean reportStop;
    private int lineAmask;
    private int lineAidx;
    private int lineBmask;
    private int lineBidx;
    private int sdaIdx;
    private int sclIdx;

    public I2CAnalyserTask(ToolContext aContext, ToolProgressListener aProgressListener, AnnotationListener aAnnotationListener) {
        this.context = aContext;
        this.progressListener = aProgressListener;
        this.annotationListener = aAnnotationListener;
        this.pcs = new PropertyChangeSupport(this);
        this.detectSDA_SCL = true;
    }

    public void addPropertyChangeListener(PropertyChangeListener aListener) {
        this.pcs.addPropertyChangeListener(aListener);
    }

    public I2CDataSet call() throws Exception {
        AcquisitionResult data = this.context.getData();
        int[] values = data.getValues();
        long[] timestamps = data.getTimestamps();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Line A mask = 0x{0}", Integer.toHexString(this.lineAmask));
            LOG.log(Level.FINE, "Line B mask = 0x{0}", Integer.toHexString(this.lineBmask));
        }
        int startOfDecode = this.context.getStartSampleIndex();
        int endOfDecode = this.context.getEndSampleIndex();
        if (this.detectSDA_SCL) {
            startOfDecode = this.autodetectDataAndClock(data, startOfDecode, endOfDecode);
        } else {
            this.sclIdx = this.lineAidx;
            this.sdaIdx = this.lineBidx;
        }
        int sdaMask = 1 << this.sdaIdx;
        int sclMask = 1 << this.sclIdx;
        I2CDataSet i2cDataSet = new I2CDataSet(startOfDecode, endOfDecode, data);
        this.prepareResults();
        int idx = i2cDataSet.getStartOfDecode();
        int prevIdx = -1;
        int oldSCL = values[idx] & sclMask;
        int oldSDA = values[idx] & sdaMask;
        int bitCount = 8;
        int byteValue = 0;
        boolean startCondFound = false;
        boolean tenBitAddress = false;
        int slaveAddress = 0;
        int direction = -1;
        if (this.detectSDA_SCL) {
            this.reportStartCondition(i2cDataSet, startOfDecode);
            this.annotationListener.onAnnotation((Annotation)new SampleDataAnnotation(this.sdaIdx, timestamps[startOfDecode], "START"));
            startCondFound = true;
        }
        while (idx < i2cDataSet.getEndOfDecode()) {
            int dataValue = values[idx];
            int sda = dataValue & sdaMask;
            int scl = dataValue & sclMask;
            if (oldSCL > scl) {
                if (prevIdx < 0 || bitCount == 8) {
                    prevIdx = idx;
                }
                if (bitCount == 0) {
                    String annotation;
                    this.reportData(i2cDataSet, prevIdx, idx, byteValue);
                    if (startCondFound) {
                        direction = byteValue & 1;
                        if ((byteValue & 0xF8) == 240) {
                            slaveAddress = (byteValue & 6) << 6;
                            tenBitAddress = true;
                            annotation = String.format("Setup %s 10-bit slave", direction == 1 ? "read from" : "write to");
                        } else {
                            slaveAddress = tenBitAddress ? (slaveAddress |= byteValue & 0xFF) : byteValue >> 1 & 0xFF;
                            startCondFound = false;
                            annotation = String.format(tenBitAddress ? "Setup %s slave: 0x%X " : "Setup %s slave: 0x%X [0x%X]", direction == 1 ? "read from" : "write to", slaveAddress, byteValue);
                            tenBitAddress = false;
                        }
                    } else {
                        annotation = String.format("%s data: 0x%X (%c)", direction == 1 ? "Read" : "Write", byteValue, byteValue);
                    }
                    this.annotationListener.onAnnotation((Annotation)new SampleDataAnnotation(this.sdaIdx, timestamps[prevIdx], timestamps[idx], annotation));
                    byteValue = 0;
                }
            } else if (scl > oldSCL) {
                if (sda != oldSDA) {
                    this.reportBusError(i2cDataSet, idx);
                } else if (bitCount != 0) {
                    --bitCount;
                    if (sda != 0) {
                        byteValue |= 1 << bitCount;
                    }
                } else {
                    if (sda != 0) {
                        this.reportNACK(i2cDataSet, idx);
                        this.annotationListener.onAnnotation((Annotation)new SampleDataAnnotation(this.sdaIdx, timestamps[idx], "NACK"));
                    } else {
                        this.reportACK(i2cDataSet, idx);
                        this.annotationListener.onAnnotation((Annotation)new SampleDataAnnotation(this.sdaIdx, timestamps[idx], "ACK"));
                    }
                    bitCount = 8;
                    byteValue = 0;
                }
            }
            if (scl == sclMask && sda != oldSDA) {
                if (bitCount > 0 && bitCount < 7) {
                    this.reportBusError(i2cDataSet, idx);
                } else {
                    if (sda > oldSDA) {
                        this.reportStopCondition(i2cDataSet, idx);
                        this.annotationListener.onAnnotation((Annotation)new SampleDataAnnotation(this.sdaIdx, timestamps[idx], "STOP"));
                        slaveAddress = 0;
                        direction = -1;
                    } else {
                        this.reportStartCondition(i2cDataSet, idx);
                        this.annotationListener.onAnnotation((Annotation)new SampleDataAnnotation(this.sdaIdx, timestamps[idx], "START"));
                        startCondFound = true;
                    }
                    bitCount = 8;
                    byteValue = 0;
                }
            }
            oldSCL = scl;
            oldSDA = sda;
            this.progressListener.setProgress(NumberUtils.getPercentage((int)idx, (int)i2cDataSet.getStartOfDecode(), (int)i2cDataSet.getEndOfDecode()));
            ++idx;
        }
        return i2cDataSet;
    }

    public void removePropertyChangeListener(PropertyChangeListener aListener) {
        this.pcs.removePropertyChangeListener(aListener);
    }

    public void setDetectSDA_SCL(boolean aDetectSDA_SCL) {
        this.detectSDA_SCL = aDetectSDA_SCL;
    }

    public void setLineAIndex(int aLineAidx) {
        this.lineAidx = aLineAidx;
        this.lineAmask = 1 << aLineAidx;
    }

    public void setLineBIndex(int aLineBidx) {
        this.lineBidx = aLineBidx;
        this.lineBmask = 1 << aLineBidx;
    }

    public void setReportACK(boolean aReportACK) {
        this.reportACK = aReportACK;
    }

    public void setReportNACK(boolean aReportNACK) {
        this.reportNACK = aReportNACK;
    }

    public void setReportStart(boolean aReportStart) {
        this.reportStart = aReportStart;
    }

    public void setReportStop(boolean aReportStop) {
        this.reportStop = aReportStop;
    }

    final int getSclIdx() {
        return this.sclIdx;
    }

    final int getSdaIdx() {
        return this.sdaIdx;
    }

    private int autodetectDataAndClock(AcquisitionResult aData, int aStartOfDecode, int aEndOfDecode) {
        int dataValue;
        int sampleIdx;
        int dataMask = this.lineAmask | this.lineBmask;
        int[] values = aData.getValues();
        for (sampleIdx = aStartOfDecode; sampleIdx < aEndOfDecode && ((dataValue = values[sampleIdx]) & dataMask) != dataMask; ++sampleIdx) {
            this.progressListener.setProgress(NumberUtils.getPercentage((int)sampleIdx, (int)aStartOfDecode, (int)aEndOfDecode));
        }
        if (sampleIdx == aEndOfDecode) {
            LOG.log(Level.WARNING, "No IDLE state found in data; aborting analysis...");
            throw new IllegalStateException("No IDLE state found!");
        }
        while (sampleIdx < aEndOfDecode) {
            int sample = values[sampleIdx];
            int dataValue2 = sample & dataMask;
            if (dataValue2 != dataMask && dataValue2 != 0) {
                int lineAvalue = sample & this.lineAmask;
                int lineBvalue = sample & this.lineBmask;
                if (lineAvalue == 0 && lineBvalue != 0) {
                    this.sdaIdx = this.lineAidx;
                    this.sclIdx = this.lineBidx;
                    break;
                }
                if (lineAvalue != 0 && lineBvalue == 0) {
                    this.sdaIdx = this.lineBidx;
                    this.sclIdx = this.lineAidx;
                    break;
                }
            }
            this.progressListener.setProgress(NumberUtils.getPercentage((int)sampleIdx, (int)aStartOfDecode, (int)aEndOfDecode));
            ++sampleIdx;
        }
        if (sampleIdx == aEndOfDecode) {
            LOG.log(Level.WARNING, "No START condition found! Analysis aborted...");
            throw new IllegalStateException("No START condition found!");
        }
        return sampleIdx;
    }

    private void prepareResults() {
        this.pcs.firePropertyChange(PROPERTY_AUTO_DETECT_SCL, null, this.sclIdx == this.lineAidx ? LINE_A : LINE_B);
        this.pcs.firePropertyChange(PROPERTY_AUTO_DETECT_SDA, null, this.sdaIdx == this.lineBidx ? LINE_B : LINE_A);
        this.annotationListener.onAnnotation((Annotation)new ChannelLabelAnnotation(this.sclIdx, CHANNEL_SCL_NAME));
        this.annotationListener.clearAnnotations(this.sclIdx);
        this.annotationListener.onAnnotation((Annotation)new ChannelLabelAnnotation(this.sdaIdx, CHANNEL_SDA_NAME));
        this.annotationListener.clearAnnotations(this.sdaIdx);
    }

    private void reportACK(I2CDataSet aDataSet, int aSampleIdx) {
        if (this.reportACK) {
            aDataSet.reportACK(this.sdaIdx, aSampleIdx);
        }
    }

    private void reportBusError(I2CDataSet aDataSet, int aSampleIdx) {
        aDataSet.reportBusError(this.sdaIdx, aSampleIdx);
    }

    private void reportData(I2CDataSet aDataSet, int aStartSampleIdx, int aEndSampleIdx, int aByteValue) {
        aDataSet.reportData(this.sdaIdx, aStartSampleIdx, aEndSampleIdx, aByteValue);
    }

    private void reportNACK(I2CDataSet aDataSet, int aSampleIdx) {
        if (this.reportNACK) {
            aDataSet.reportNACK(this.sdaIdx, aSampleIdx);
        }
    }

    private void reportStartCondition(I2CDataSet aDataSet, int aSampleIdx) {
        if (this.reportStart) {
            aDataSet.reportStartCondition(this.sdaIdx, aSampleIdx);
        }
    }

    private void reportStopCondition(I2CDataSet aDataSet, int aSampleIdx) {
        if (this.reportStop) {
            aDataSet.reportStopCondition(this.sdaIdx, aSampleIdx);
        }
    }
}

