/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.device.test;

import java.util.ArrayList;
import java.util.List;

final class ManchesterEncoder {
    private static final int LINE_IDX = 2;
    private final List<Integer> data = new ArrayList<Integer>();
    private final int sampleRate;
    private final int clockSpeed;
    private final int bitBoundary = (int)Math.rint((double)this.sampleRate / (double)this.clockSpeed);
    private final int setupPoint = this.bitBoundary / 2;
    private final int trigger;

    public ManchesterEncoder() {
        this.clockSpeed = 1020304;
        this.sampleRate = 2750000;
        for (int i = 0; i < 5 * this.bitBoundary; ++i) {
            this.data.add(4);
        }
        this.trigger = this.data.size();
        this.write((byte)-86);
    }

    public int[] getData() {
        int size = this.data.size();
        int[] result = new int[size];
        for (int i = 0; i < size; ++i) {
            result[i] = this.data.get(i);
        }
        return result;
    }

    public int getRate() {
        return this.sampleRate;
    }

    public int getTrigger() {
        return this.trigger;
    }

    public void writeData(String aString) {
        byte[] bytes;
        for (byte b : bytes = aString.getBytes()) {
            this.write(b);
        }
        for (int i = 0; i < 3 * this.bitBoundary; ++i) {
            this.data.add(4);
        }
        this.data.add(1);
    }

    private void write(byte aByte) {
        for (int i = 7; i >= 0; --i) {
            int b = aByte & 1 << i;
            this.writeBit(b);
        }
    }

    private void writeBit(int aBitValue) {
        if (aBitValue != 0) {
            this.writeManchesterOne();
        } else {
            this.writeManchesterZero();
        }
    }

    private void writeManchesterOne() {
        int i;
        Integer low = 0;
        Integer high = 4;
        for (i = 0; i < this.setupPoint; ++i) {
            this.data.add(low);
        }
        for (i = 0; i < this.setupPoint; ++i) {
            this.data.add(high);
        }
    }

    private void writeManchesterZero() {
        int i;
        Integer low = 0;
        Integer high = 4;
        for (i = 0; i < this.setupPoint; ++i) {
            this.data.add(high);
        }
        for (i = 0; i < this.setupPoint; ++i) {
            this.data.add(low);
        }
    }
}

