/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import nl.lxtreme.ols.api.data.Cursor;
import nl.lxtreme.ols.api.data.DataSet;
import nl.lxtreme.ols.client.signaldisplay.ICursorChangeListener;
import nl.lxtreme.ols.client.signaldisplay.IDataModelChangeListener;
import nl.lxtreme.ols.client.signaldisplay.IToolWindow;
import nl.lxtreme.ols.client.signaldisplay.SignalDiagramController;
import nl.lxtreme.ols.client.signaldisplay.model.SignalDiagramModel;
import nl.lxtreme.ols.client.signaldisplay.util.ClickableLink;
import nl.lxtreme.ols.client.signaldisplay.util.CursorFlagTextFormatter;
import nl.lxtreme.ols.client.signaldisplay.view.AbstractViewLayer;
import nl.lxtreme.ols.util.swing.SpringLayoutUtils;
import nl.lxtreme.ols.util.swing.SwingComponentUtils;

public class CursorDetailsView
extends AbstractViewLayer
implements IToolWindow,
ICursorChangeListener,
IDataModelChangeListener,
ClickableLink.LinkListener {
    public static final String ID = "Cursor";
    private static final long serialVersionUID = 1L;

    private CursorDetailsView(SignalDiagramController aController) {
        super(aController);
        this.initComponent();
    }

    public static CursorDetailsView create(SignalDiagramController aController) {
        CursorDetailsView result = new CursorDetailsView(aController);
        aController.addCursorChangeListener(result);
        aController.addDataModelChangeListener(result);
        return result;
    }

    @Override
    public void cursorAdded(Cursor aCursor) {
        this.updateViewText();
    }

    @Override
    public void cursorChanged(String aPropertyName, Cursor aOldCursor, Cursor aNewCursor) {
        if (!"color".equals(aPropertyName)) {
            this.updateViewText();
        }
    }

    @Override
    public void cursorRemoved(Cursor aOldCursor) {
        this.updateViewText();
    }

    @Override
    public void cursorsInvisible() {
        this.updateViewText();
    }

    @Override
    public void cursorsVisible() {
        this.updateViewText();
    }

    @Override
    public void dataModelChanged(DataSet aDataSet) {
        this.updateViewText();
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void linkActivated(Object aLinkId) {
        if (aLinkId instanceof Long) {
            long timestamp = (Long)aLinkId;
            this.getController().getSignalDiagram().scrollToTimestamp(timestamp);
        }
    }

    private void initComponent() {
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.setName("Cursor details");
        this.updateViewText();
    }

    private void updateViewText() {
        boolean cursorsEnabled;
        Cursor[] cursors;
        SignalDiagramController ctrl = this.getController();
        final SignalDiagramModel model = ctrl.getSignalDiagramModel();
        if (model != null) {
            cursors = model.getDefinedCursors();
            cursorsEnabled = model.isCursorMode();
        } else {
            cursors = new Cursor[]{};
            cursorsEnabled = false;
        }
        SwingComponentUtils.invokeOnEDT((Runnable)new Runnable(){

            @Override
            public void run() {
                JPanel panel = new JPanel(new SpringLayout());
                SpringLayoutUtils.addSeparator((Container)panel, (String)"Cursors");
                for (Cursor cursor : cursors) {
                    String label = "" + (cursor.getIndex() + 1);
                    if (cursor.hasLabel()) {
                        label = label.concat(", ").concat(cursor.getLabel());
                    }
                    panel.add(SwingComponentUtils.createRightAlignedLabel((String)label.concat(":")));
                    String linkText = CursorFlagTextFormatter.getCursorFlagText(model, cursor, CursorFlagTextFormatter.LabelStyle.TIME_ONLY);
                    ClickableLink link = new ClickableLink(linkText, cursor.getTimestamp());
                    link.setLinkListener(CursorDetailsView.this);
                    link.setEnabled(cursorsEnabled);
                    link.setForeground(Color.BLUE);
                    panel.add(link);
                }
                if (cursors.length == 0) {
                    panel.add(SwingComponentUtils.createRightAlignedLabel((String)"No"));
                    panel.add(new JLabel("cursors defined."));
                }
                SpringLayoutUtils.makeEditorGrid((Container)panel, (int)10, (int)10);
                CursorDetailsView.this.removeAll();
                CursorDetailsView.this.add((Component)panel, "North");
                CursorDetailsView.this.validate();
                CursorDetailsView.this.repaint();
            }
        });
    }
}

