/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.action;

import java.awt.AWTEvent;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import nl.lxtreme.ols.client.ClientController;
import nl.lxtreme.ols.client.action.BaseAction;
import nl.lxtreme.ols.util.HostUtils;
import nl.lxtreme.ols.util.swing.SwingComponentUtils;
import nl.lxtreme.ols.util.swing.component.JErrorDialog;

public class OpenProjectAction
extends BaseAction {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(OpenProjectAction.class.getName());
    public static final String OLS_PROJECT_EXTENSION = "olp";
    public static final FileFilter OLS_PROJECT_FILTER = new FileNameExtensionFilter("OpenLogic Sniffer project file", "olp");
    public static final String ID = "OpenProject";

    public OpenProjectAction(ClientController aController) {
        super(ID, aController, "document-open.png", "Open project ...", "Open an existing project");
        this.putValue("AcceleratorKey", SwingComponentUtils.createMenuKeyMask((int)79, (int[])new int[0]));
        this.putValue("MnemonicKey", 80);
    }

    @Override
    public void actionPerformed(ActionEvent aEvent) {
        block4: {
            Window parent = SwingComponentUtils.getOwningWindow((AWTEvent)aEvent);
            ClientController controller = this.getController();
            if (controller.isProjectChanged() && !SwingComponentUtils.askConfirmation((Window)parent, (String)"Current project has been changed.\nDo you really want to lose your changes?")) {
                return;
            }
            File file = SwingComponentUtils.showFileOpenDialog((Window)parent, (FileFilter[])new FileFilter[]{OLS_PROJECT_FILTER});
            if (file != null) {
                LOG.log(Level.INFO, "Loading project data from file: {0}", file);
                try {
                    controller.openProjectFile(file);
                }
                catch (IOException exception) {
                    if (HostUtils.handleInterruptedException((Throwable)exception)) break block4;
                    LOG.log(Level.WARNING, "Loading OLS project failed!", exception);
                    JErrorDialog.showDialog((Window)parent, (String)"Loading the project data failed!", (Throwable)exception);
                }
            }
        }
    }
}

