/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.export.csv;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import nl.lxtreme.ols.api.acquisition.AcquisitionResult;
import nl.lxtreme.ols.api.data.Channel;
import nl.lxtreme.ols.api.data.DataSet;
import nl.lxtreme.ols.api.data.export.Exporter;

public class CsvExporter
implements Exporter {
    private final char colSeparator = (char)44;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(DataSet aDataSet, JComponent aComponent, OutputStream aStream) throws IOException {
        PrintStream stream = new PrintStream(aStream);
        try {
            this.writeHeaderRow(stream, this.createHeaderRowValues(aDataSet));
            Channel[] channels = aDataSet.getChannels();
            AcquisitionResult capturedData = aDataSet.getCapturedData();
            int sampleRate = capturedData.getSampleRate();
            int[] values = capturedData.getValues();
            long[] timestamps = capturedData.getTimestamps();
            long triggerPos = capturedData.getTriggerPosition();
            for (int i = 0; i < values.length; ++i) {
                this.writeDataRow(stream, timestamps[i], triggerPos, sampleRate, values[i], channels);
            }
        }
        finally {
            stream.flush();
        }
    }

    public String[] getFilenameExtentions() {
        return new String[]{"csv"};
    }

    public String getName() {
        return "CSV File";
    }

    private void createChannelHeaders(List<String> aList, Channel[] aChannels) {
        int insertIdx = aList.size();
        for (int i = 0; i < aChannels.length; ++i) {
            String label = aChannels[i].getLabel();
            if (label == null) {
                label = String.format("Ch.%d", i);
            }
            aList.add(insertIdx, label);
        }
    }

    private String[] createHeaderRowValues(DataSet aDataSet) {
        Channel[] channels = aDataSet.getChannels();
        AcquisitionResult capturedData = aDataSet.getCapturedData();
        long triggerPos = capturedData.getTriggerPosition();
        int sampleRate = capturedData.getSampleRate();
        ArrayList<String> result = new ArrayList<String>();
        if (sampleRate > 0) {
            result.add("timestamp (abs)");
        } else {
            result.add("state (abs)");
        }
        if (triggerPos > 0L) {
            if (sampleRate > 0) {
                result.add("timestamp (rel)");
            } else {
                result.add("state (rel)");
            }
        }
        if (sampleRate > 0) {
            result.add("sample rate (Hz)");
        }
        this.createChannelHeaders(result, channels);
        return result.toArray(new String[result.size()]);
    }

    private String quote(String aValue) {
        return String.format("\"%s\"", aValue);
    }

    private void writeDataRow(PrintStream aStream, long aAbsTime, long aTriggerPos, int aSampleRate, int aValue, Channel[] aChannels) throws IOException {
        aStream.print(aAbsTime);
        if (aTriggerPos > 0L) {
            aStream.print(this.colSeparator);
            aStream.print(aAbsTime - aTriggerPos);
        }
        if (aSampleRate > 0) {
            aStream.print(this.colSeparator);
            aStream.print(aSampleRate);
        }
        if (aChannels != null) {
            int l = aChannels.length;
            for (int i = 0; i < l; ++i) {
                Channel channel = aChannels[l - i - 1];
                int v = (aValue & channel.getMask()) >> channel.getIndex();
                aStream.print(this.colSeparator);
                aStream.print(v);
            }
        }
        aStream.println();
    }

    private void writeHeaderRow(PrintStream aStream, String[] aHeaders) throws IOException {
        for (int i = 0; i < aHeaders.length; ++i) {
            if (i > 0) {
                aStream.print(this.colSeparator);
            }
            aStream.print(this.quote(aHeaders[i]));
        }
        aStream.println();
    }
}

