/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.util.swing.component;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import nl.lxtreme.ols.util.swing.component.icon.TriangleSquareWindowsCornerIcon;

public class JStatusBar
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected static final int HEIGHT = 23;
    protected static final Insets INSETS = new Insets(0, 4, 0, 2);
    private final JPanel contentPanel;
    private JComponent mainLeftComponent;

    public JStatusBar() {
        this.setPreferredSize(new Dimension(this.getWidth(), 23));
        this.setLayout(new BorderLayout());
        JPanel rightPanel = new JPanel(new BorderLayout());
        rightPanel.setOpaque(false);
        if (!this.isMacOSX()) {
            JLabel resizeIconLabel = new JLabel(new TriangleSquareWindowsCornerIcon());
            resizeIconLabel.setOpaque(false);
            rightPanel.add((Component)resizeIconLabel, "South");
        } else {
            JLabel comp = new JLabel(" ");
            comp.setPreferredSize(new Dimension(12, 12));
            rightPanel.add((Component)comp, "South");
        }
        this.add((Component)rightPanel, "East");
        this.contentPanel = new JPanel(new GridBagLayout());
        this.contentPanel.setOpaque(false);
        this.add((Component)this.contentPanel, "Center");
    }

    public void addRightComponent(JComponent aComponent) {
        int i = this.contentPanel.getComponentCount();
        GridBagConstraints gbc = new GridBagConstraints(i, 0, 1, 1, 0.0, 1.0, 10, 0, INSETS, 0, 0);
        this.contentPanel.add((Component)new SeparatorPanel(Color.GRAY, Color.WHITE), gbc);
        gbc.anchor = 10;
        ++gbc.gridx;
        this.contentPanel.add((Component)aComponent, gbc);
        this.revalidate();
    }

    public void setMainLeftComponent(JComponent aComponent) {
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, INSETS, 0, 0);
        if (this.mainLeftComponent != null) {
            this.contentPanel.remove(this.mainLeftComponent);
        }
        this.mainLeftComponent = aComponent;
        this.contentPanel.add((Component)this.mainLeftComponent, gbc);
        this.revalidate();
    }

    @Override
    protected void paintComponent(Graphics aCanvas) {
        Color color1 = this.getBackground();
        Color color2 = color1.darker();
        GradientPaint gp = new GradientPaint(0.0f, 0.0f, color1, this.getWidth(), this.getHeight(), color2);
        ((Graphics2D)aCanvas).setPaint(gp);
        aCanvas.fillRect(0, 0, this.getWidth(), this.getHeight());
        super.paintComponent(aCanvas);
    }

    private boolean isMacOSX() {
        String osName = System.getProperty("os.name");
        return "Mac OS X".equalsIgnoreCase(osName);
    }

    static final class SeparatorPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private final Color leftColor;
        private final Color rightColor;

        public SeparatorPanel(Color aLeftColor, Color aRightColor) {
            this.leftColor = aLeftColor;
            this.rightColor = aRightColor;
            this.setOpaque(false);
            this.setSize(new Dimension(4, this.getHeight()));
        }

        @Override
        protected void paintComponent(Graphics aCanvas) {
            aCanvas.setColor(this.leftColor);
            aCanvas.drawLine(0, 0, 0, this.getHeight());
            aCanvas.setColor(this.rightColor);
            aCanvas.drawLine(1, 0, 1, this.getHeight());
        }
    }
}

