/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.util.swing.component;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.Timer;
import nl.lxtreme.ols.util.ColorUtils;

public class JBusyIndicator
extends JComponent {
    private static final long serialVersionUID = 1L;
    private volatile int frameCounter;
    private final Timer timer;
    private final int barCount;
    private final float barWidth;
    private final float barLength;
    private final float centerDistance;
    private final Color baseColor = Color.LIGHT_GRAY;
    private final Color highlightColor = Color.BLACK;
    private final int trailLength = this.barCount / 2;

    public JBusyIndicator() {
        this.barCount = 12;
        this.barWidth = 1.3f;
        this.barLength = 4.5f;
        this.centerDistance = 3.5f;
        this.timer = new Timer(75, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aEvent) {
                JBusyIndicator.this.increaseFrameCounter();
                JBusyIndicator.this.repaint();
            }
        });
        this.timer.setInitialDelay(10);
        this.timer.setRepeats(true);
        this.timer.setCoalesce(true);
        this.setOpaque(false);
        Dimension dim = new Dimension(24, 24);
        this.setPreferredSize(dim);
        this.setMinimumSize(dim);
        this.setMaximumSize(dim);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.isVisible()) {
            this.startAnimation();
        }
    }

    @Override
    public void removeNotify() {
        this.stopAnimation();
        super.removeNotify();
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        if (aFlag) {
            this.startAnimation();
        } else if (!aFlag) {
            this.stopAnimation();
            this.repaint();
        }
    }

    final void increaseFrameCounter() {
        this.frameCounter = (this.frameCounter + 1) % this.barCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics aGraphics) {
        Graphics2D canvas = (Graphics2D)aGraphics.create();
        try {
            if (this.timer.isRunning()) {
                RoundRectangle2D.Float rect = new RoundRectangle2D.Float(this.centerDistance, -this.barWidth / 2.0f, this.barLength, this.barWidth, this.barWidth, this.barWidth);
                canvas.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                canvas.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                canvas.setColor(Color.GRAY);
                canvas.translate(this.getWidth() / 2, this.getHeight() / 2);
                for (int i = 0; i < this.barCount; ++i) {
                    canvas.setColor(this.calculateBarColor(i));
                    canvas.fill(rect);
                    canvas.rotate(Math.PI * 2 / (double)this.barCount);
                }
            } else {
                canvas.setColor(this.getBackground());
                canvas.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        }
        finally {
            canvas.dispose();
            canvas = null;
        }
    }

    private Color calculateBarColor(int aBarIdx) {
        for (int t = 0; t < this.trailLength; ++t) {
            if (aBarIdx != (this.frameCounter - t + this.barCount) % this.barCount) continue;
            float terp = 1.0f - (float)(this.trailLength - t) / (float)this.trailLength;
            return ColorUtils.interpolate(this.baseColor, this.highlightColor, terp);
        }
        return this.baseColor;
    }

    private void startAnimation() {
        if (!this.timer.isRunning()) {
            this.timer.start();
        }
    }

    private void stopAnimation() {
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
    }
}

