/*
 * Decompiled with CFR 0.152.
 */
package org.sump.device.logicsniffer.protocol;

import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.lxtreme.ols.util.NumberUtils;
import org.sump.device.logicsniffer.LogicSnifferConfig;
import org.sump.device.logicsniffer.profile.DeviceProfile;
import org.sump.device.logicsniffer.protocol.SumpProtocolConstants;

public class SumpCommandWriter
implements SumpProtocolConstants,
Closeable {
    private static final int SETTRIGMASK = 192;
    private static final int SETTRIGVAL = 193;
    private static final int SETTRIGCFG = 194;
    private static final int SETDIVIDER = 128;
    private static final int SETSIZE = 129;
    private static final int SETFLAGS = 130;
    public static final int FLAG_DEMUX = 1;
    public static final int FLAG_FILTER = 2;
    public static final int FLAG_GROUP1_DISABLED = 4;
    public static final int FLAG_GROUP2_DISABLED = 8;
    public static final int FLAG_GROUP3_DISABLED = 16;
    public static final int FLAG_GROUP4_DISABLED = 32;
    public static final int FLAG_EXTERNAL = 64;
    public static final int FLAG_INVERTED = 128;
    public static final int FLAG_RLE = 256;
    public static final int FLAG_RLE_MODE_0 = 0;
    public static final int FLAG_RLE_MODE_1 = 16384;
    public static final int FLAG_RLE_MODE_2 = 32768;
    public static final int FLAG_RLE_MODE_3 = 49152;
    public static final int FLAG_NUMBER_SCHEME = 512;
    public static final int FLAG_EXTERNAL_TEST_MODE = 1024;
    public static final int FLAG_INTERNAL_TEST_MODE = 2048;
    private static final Logger LOG = Logger.getLogger(SumpCommandWriter.class.getName());
    protected final LogicSnifferConfig config;
    private final DataOutputStream outputStream;

    public SumpCommandWriter(LogicSnifferConfig aConfiguration, DataOutputStream aOutputStream) {
        this.config = aConfiguration;
        this.outputStream = aOutputStream;
    }

    private static int determineRleMode() {
        return NumberUtils.smartParseInt((String)System.getProperty("nl.lxtreme.ols.rle.mode"), (int)1);
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }

    public void writeCmdFinishNow() throws IOException {
        boolean isRleEnabled = this.config.isRleEnabled();
        if (isRleEnabled) {
            LOG.info("Prematurely finishing RLE-enabled capture ...");
            this.sendCommand(5);
        } else {
            LOG.info("Prematurely finishing normal capture ...");
            this.writeCmdReset();
        }
    }

    public void writeCmdGetId() throws IOException {
        this.sendCommand(2);
    }

    public void writeCmdGetMetadata() throws IOException {
        this.sendCommand(4);
    }

    public void writeCmdReset() throws IOException {
        for (int i = 0; i < 5; ++i) {
            this.sendCommand(0);
        }
    }

    public void writeCmdRun() throws IOException {
        this.sendCommand(1);
    }

    public int writeDeviceConfiguration() throws IOException {
        int trigcount;
        int size;
        int maxSize;
        this.sendCommand(128, this.config.getDivider());
        int stopCounter = this.configureTriggers();
        int readCounter = this.config.getReadCounter();
        if (this.config.isDoubleDataRateEnabled()) {
            maxSize = 524280;
            size = (stopCounter & 0x7FFF8) << 13 | ((readCounter & 0x7FFF8) >> 3) - 1;
            trigcount = ((size & 0xFFFF) << 3) - ((size >> 16 & 0xFFFF) << 3);
        } else {
            maxSize = 262140;
            size = (stopCounter & 0x3FFFC) << 14 | ((readCounter & 0x3FFFC) >> 2) - 1;
            trigcount = ((size & 0xFFFF) << 2) - ((size >> 16 & 0xFFFF) << 2);
        }
        this.sendCommand(129, size);
        int flags = 0;
        if (this.config.isExternalClock()) {
            flags |= 0x40;
            if (DeviceProfile.CaptureClockSource.EXTERNAL_FALLING == this.config.getClockSource()) {
                flags |= 0x80;
            }
        }
        int enabledChannelGroups = 0;
        for (int i = 0; i < this.config.getGroupCount(); ++i) {
            if (!this.config.isGroupEnabled(i)) continue;
            enabledChannelGroups |= 1 << i;
        }
        if (this.config.isDoubleDataRateEnabled()) {
            enabledChannelGroups |= (enabledChannelGroups & 3) << 2 & 0xC;
            flags |= 1;
            flags &= 0xFFFFFFFD;
        }
        flags |= ~(enabledChannelGroups << 2) & 0x3C;
        if (this.config.isFilterEnabled() && this.config.isFilterAvailable()) {
            flags |= 2;
            flags &= 0xFFFFFFFE;
        }
        if (this.config.isRleEnabled()) {
            flags |= 0x100;
            int rleMode = SumpCommandWriter.determineRleMode();
            switch (rleMode) {
                case 3: {
                    flags |= 0xC000;
                    break;
                }
                case 2: {
                    flags |= 0x8000;
                    break;
                }
                case 0: {
                    flags |= 0;
                    break;
                }
                default: {
                    flags |= 0x4000;
                }
            }
        }
        if (this.config.isAltNumberSchemeEnabled()) {
            flags |= 0x200;
        }
        if (this.config.isTestModeEnabled()) {
            flags |= 0x400;
        }
        LOG.log(Level.FINE, "Flags: 0b{0}", Integer.toBinaryString(flags));
        this.sendCommand(130, flags);
        return trigcount;
    }

    protected final void sendCommand(int aOpcode) throws IOException {
        if (LOG.isLoggable(Level.ALL) || LOG.isLoggable(Level.FINE)) {
            byte opcode = (byte)(aOpcode & 0xFF);
            LOG.log(Level.FINE, "Sending short command: {0} ({1})", new Object[]{Integer.toHexString(opcode), Integer.toBinaryString(opcode)});
        }
        this.outputStream.writeByte(aOpcode);
        this.outputStream.flush();
    }

    protected final void sendCommand(int aOpcode, int aData) throws IOException {
        if (LOG.isLoggable(Level.ALL) || LOG.isLoggable(Level.FINE)) {
            byte opcode = (byte)(aOpcode & 0xFF);
            LOG.log(Level.FINE, "Sending long command: {0} ({1}) with data {2} ({3})", new Object[]{Integer.toHexString(opcode), Integer.toBinaryString(opcode), Integer.toHexString(aData), Integer.toBinaryString(aData)});
        }
        byte[] raw = new byte[5];
        int mask = 255;
        int shift = 0;
        raw[0] = (byte)aOpcode;
        for (int i = 1; i < 5; ++i) {
            raw[i] = (byte)((aData & mask) >> shift);
            mask <<= 8;
            shift += 8;
        }
        this.outputStream.write(raw);
        this.outputStream.flush();
    }

    private int configureTriggers() throws IOException {
        int effectiveStopCounter;
        if (this.config.isTriggerEnabled()) {
            for (int i = 0; i < this.config.getMaxTriggerStages(); ++i) {
                int indexMask = 4 * i;
                this.sendCommand(0xC0 | indexMask, this.config.getTriggerMask(i));
                this.sendCommand(0xC1 | indexMask, this.config.getTriggerValue(i));
                this.sendCommand(0xC2 | indexMask, this.config.getTriggerConfig(i));
            }
            effectiveStopCounter = this.config.getStopCounter();
        } else {
            this.sendCommand(192, 0);
            this.sendCommand(193, 0);
            this.sendCommand(194, 0x8000000);
            effectiveStopCounter = this.config.getReadCounter();
        }
        return effectiveStopCounter;
    }
}

