/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.tool.i2c;

import nl.lxtreme.ols.api.acquisition.AcquisitionResult;
import nl.lxtreme.ols.api.data.BaseDataSet;
import nl.lxtreme.ols.tool.i2c.I2CData;

public final class I2CDataSet
extends BaseDataSet<I2CData> {
    public static final String I2C_ACK = "ACK";
    public static final String I2C_BUS_ERROR = "BUS-ERROR";
    public static final String I2C_NACK = "NACK";
    public static final String I2C_START = "START";
    public static final String I2C_STOP = "STOP";
    private int busErrors = 0;
    private int decodedBytes = 0;

    public I2CDataSet(int aStartSampleIdx, int aStopSampleIdx, AcquisitionResult aData) {
        super(aStartSampleIdx, aStopSampleIdx, aData);
    }

    public int getBusErrorCount() {
        return this.busErrors;
    }

    public int getDecodedByteCount() {
        return this.decodedBytes;
    }

    public void reportACK(int aChannelIdx, int aSampleIdx) {
        int idx = this.size();
        this.addData(new I2CData(idx, aChannelIdx, aSampleIdx, I2C_ACK));
    }

    public void reportBusError(int aChannelIdx, int aSampleIdx) {
        int idx = this.size();
        ++this.busErrors;
        this.addData(new I2CData(idx, aChannelIdx, aSampleIdx, I2C_BUS_ERROR));
    }

    public void reportData(int aChannelIdx, int aStartSampleIdx, int aEndSampleIdx, int aByteValue) {
        int idx = this.size();
        ++this.decodedBytes;
        this.addData(new I2CData(idx, aChannelIdx, aStartSampleIdx, aEndSampleIdx, aByteValue));
    }

    public void reportNACK(int aChannelIdx, int aSampleIdx) {
        int idx = this.size();
        this.addData(new I2CData(idx, aChannelIdx, aSampleIdx, I2C_NACK));
    }

    public void reportStartCondition(int aChannelIdx, int aSampleIdx) {
        int idx = this.size();
        this.addData(new I2CData(idx, aChannelIdx, aSampleIdx, I2C_START));
    }

    public void reportStopCondition(int aChannelIdx, int aSampleIdx) {
        int idx = this.size();
        this.addData(new I2CData(idx, aChannelIdx, aSampleIdx, I2C_STOP));
    }
}

