/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.fileinstall.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import org.apache.felix.fileinstall.ArtifactInstaller;
import org.apache.felix.fileinstall.ArtifactListener;
import org.apache.felix.fileinstall.ArtifactTransformer;
import org.apache.felix.fileinstall.ArtifactUrlTransformer;
import org.apache.felix.fileinstall.internal.Artifact;
import org.apache.felix.fileinstall.internal.FileInstall;
import org.apache.felix.fileinstall.internal.Scanner;
import org.apache.felix.fileinstall.internal.Util;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Parser;
import org.apache.felix.utils.version.VersionRange;
import org.apache.felix.utils.version.VersionTable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;

public class DirectoryWatcher
extends Thread
implements BundleListener {
    public static final String FILENAME = "felix.fileinstall.filename";
    public static final String POLL = "felix.fileinstall.poll";
    public static final String DIR = "felix.fileinstall.dir";
    public static final String LOG_LEVEL = "felix.fileinstall.log.level";
    public static final String TMPDIR = "felix.fileinstall.tmpdir";
    public static final String FILTER = "felix.fileinstall.filter";
    public static final String START_NEW_BUNDLES = "felix.fileinstall.bundles.new.start";
    public static final String USE_START_TRANSIENT = "felix.fileinstall.bundles.startTransient";
    public static final String USE_START_ACTIVATION_POLICY = "felix.fileinstall.bundles.startActivationPolicy";
    public static final String NO_INITIAL_DELAY = "felix.fileinstall.noInitialDelay";
    public static final String DISABLE_CONFIG_SAVE = "felix.fileinstall.disableConfigSave";
    public static final String ENABLE_CONFIG_SAVE = "felix.fileinstall.enableConfigSave";
    public static final String START_LEVEL = "felix.fileinstall.start.level";
    public static final String ACTIVE_LEVEL = "felix.fileinstall.active.level";
    public static final String UPDATE_WITH_LISTENERS = "felix.fileinstall.bundles.updateWithListeners";
    static final SecureRandom random = new SecureRandom();
    final File javaIoTmpdir = new File(System.getProperty("java.io.tmpdir"));
    Dictionary properties;
    File watchedDirectory;
    File tmpDir;
    long poll;
    int logLevel;
    boolean startBundles;
    boolean useStartTransient;
    boolean useStartActivationPolicy;
    String filter;
    BundleContext context;
    String originatingFileName;
    boolean noInitialDelay;
    int startLevel;
    int activeLevel;
    boolean updateWithListeners;
    Map currentManagedArtifacts = new HashMap();
    Scanner scanner;
    Set processingFailures = new HashSet();
    Set delayedStart = new HashSet();
    Map installationFailures = new HashMap();

    public DirectoryWatcher(Dictionary properties, BundleContext context) {
        super("fileinstall-" + DirectoryWatcher.getThreadName(properties));
        this.properties = properties;
        this.context = context;
        this.poll = this.getLong(properties, POLL, 2000L);
        this.logLevel = this.getInt(properties, LOG_LEVEL, Util.getGlobalLogLevel(context));
        this.originatingFileName = (String)properties.get(FILENAME);
        this.watchedDirectory = this.getFile(properties, DIR, new File("./load"));
        this.verifyWatchedDir();
        this.tmpDir = this.getFile(properties, TMPDIR, null);
        this.prepareTempDir();
        this.startBundles = this.getBoolean(properties, START_NEW_BUNDLES, true);
        this.useStartTransient = this.getBoolean(properties, USE_START_TRANSIENT, false);
        this.useStartActivationPolicy = this.getBoolean(properties, USE_START_ACTIVATION_POLICY, true);
        this.filter = (String)properties.get(FILTER);
        this.noInitialDelay = this.getBoolean(properties, NO_INITIAL_DELAY, false);
        this.startLevel = this.getInt(properties, START_LEVEL, 0);
        this.activeLevel = this.getInt(properties, ACTIVE_LEVEL, 0);
        this.updateWithListeners = this.getBoolean(properties, UPDATE_WITH_LISTENERS, false);
        this.context.addBundleListener((BundleListener)this);
        FilenameFilter flt = this.filter != null && this.filter.length() > 0 ? new FilenameFilter(){
            Pattern pattern;
            {
                this.pattern = Pattern.compile(DirectoryWatcher.this.filter);
            }

            public boolean accept(File dir, String name) {
                return this.pattern.matcher(name).matches();
            }
        } : null;
        this.scanner = new Scanner(this.watchedDirectory, flt);
    }

    private void verifyWatchedDir() {
        if (!this.watchedDirectory.exists()) {
            this.log(2, this.watchedDirectory + " does not exist, please create it.", null);
        } else if (!this.watchedDirectory.isDirectory()) {
            this.log(1, "Cannot use " + this.watchedDirectory + " because it's not a directory", null);
            throw new RuntimeException("File Install can't monitor " + this.watchedDirectory + " because it is not a directory");
        }
    }

    public static String getThreadName(Dictionary properties) {
        return (properties.get(DIR) != null ? properties.get(DIR) : "./load").toString();
    }

    public Dictionary getProperties() {
        return this.properties;
    }

    public void start() {
        if (this.noInitialDelay) {
            this.log(4, "Starting initial scan", null);
            this.initializeCurrentManagedBundles();
            Set files = this.scanner.scan(true);
            if (files != null) {
                this.process(files);
            }
        }
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = FileInstall.barrier;
        synchronized (object) {
            while (!FileInstall.initialized) {
                try {
                    FileInstall.barrier.wait(0L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.log(3, "Watcher for " + this.watchedDirectory + " exiting because of interruption.", e);
                    return;
                }
            }
        }
        this.log(4, "{felix.fileinstall.poll (ms) = " + this.poll + ", " + DIR + " = " + this.watchedDirectory.getAbsolutePath() + ", " + LOG_LEVEL + " = " + this.logLevel + ", " + START_NEW_BUNDLES + " = " + this.startBundles + ", " + TMPDIR + " = " + this.tmpDir + ", " + FILTER + " = " + this.filter + ", " + START_LEVEL + " = " + this.startLevel + "}", null);
        if (!this.noInitialDelay) {
            try {
                Thread.sleep(this.poll);
            }
            catch (InterruptedException e) {
                this.log(4, "Watcher for " + this.watchedDirectory + " was interrupted while waiting " + this.poll + " milliseconds for initial directory scan.", e);
                return;
            }
            this.initializeCurrentManagedBundles();
        }
        while (!DirectoryWatcher.interrupted()) {
            try {
                Object files;
                if (FileInstall.getStartLevel().getStartLevel() >= this.activeLevel && this.context.getBundle(0L).getState() == 32 && (files = this.scanner.scan(false)) != null) {
                    this.process((Set)files);
                }
                files = this;
                synchronized (files) {
                    this.wait(this.poll);
                }
            }
            catch (InterruptedException e) {
                return;
            }
            catch (Throwable e) {
                try {
                    this.context.getBundle();
                }
                catch (IllegalStateException t) {
                    return;
                }
                this.log(1, "In main loop, we have serious trouble", e);
            }
        }
    }

    public void bundleChanged(BundleEvent bundleEvent) {
        if (bundleEvent.getType() == 16) {
            Iterator it = this.currentManagedArtifacts.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Artifact artifact = (Artifact)entry.getValue();
                if (artifact.getBundleId() != bundleEvent.getBundle().getBundleId()) continue;
                this.log(4, "Bundle " + bundleEvent.getBundle().getBundleId() + " has been uninstalled", null);
                it.remove();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(Set files) {
        List listeners = FileInstall.getListeners();
        ArrayList<Artifact> deleted = new ArrayList<Artifact>();
        ArrayList<Artifact> modified = new ArrayList<Artifact>();
        ArrayList<Artifact> created = new ArrayList<Artifact>();
        Set set = this.processingFailures;
        synchronized (set) {
            files.addAll(this.processingFailures);
            this.processingFailures.clear();
        }
        Iterator it = files.iterator();
        while (it.hasNext()) {
            Set set2;
            ArtifactListener listener;
            File file = (File)it.next();
            boolean exists = file.exists();
            Artifact artifact = (Artifact)this.currentManagedArtifacts.get(file);
            if (!exists) {
                if (artifact == null) continue;
                this.deleteJaredDirectory(artifact);
                this.deleteTransformedFile(artifact);
                deleted.add(artifact);
                continue;
            }
            File jar = file;
            URL jaredUrl = null;
            try {
                jaredUrl = file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            if (file.isDirectory()) {
                this.prepareTempDir();
                try {
                    jar = new File(this.tmpDir, file.getName() + ".jar");
                    Util.jarDir(file, jar);
                    jaredUrl = new URL("jardir", null, file.getPath());
                }
                catch (IOException e) {
                    this.log(1, "Unable to create jar for: " + file.getAbsolutePath(), e);
                    continue;
                }
            }
            if (artifact != null) {
                artifact.setChecksum(this.scanner.getChecksum(file));
                if (artifact.getListener() == null) {
                    listener = this.findListener(jar, listeners);
                    if (listener == null) {
                        set2 = this.processingFailures;
                        synchronized (set2) {
                            this.processingFailures.add(file);
                            continue;
                        }
                    }
                    artifact.setListener(listener);
                }
                if (!listeners.contains(artifact.getListener()) || !artifact.getListener().canHandle(jar)) {
                    deleted.add(artifact);
                    artifact = null;
                    continue;
                }
                this.deleteTransformedFile(artifact);
                artifact.setJaredDirectory(jar);
                artifact.setJaredUrl(jaredUrl);
                if (this.transformArtifact(artifact)) {
                    modified.add(artifact);
                    continue;
                }
                this.deleteJaredDirectory(artifact);
                deleted.add(artifact);
                continue;
            }
            listener = this.findListener(jar, listeners);
            if (listener == null) {
                set2 = this.processingFailures;
                synchronized (set2) {
                    this.processingFailures.add(file);
                    continue;
                }
            }
            artifact = new Artifact();
            artifact.setPath(file);
            artifact.setJaredDirectory(jar);
            artifact.setJaredUrl(jaredUrl);
            artifact.setListener(listener);
            artifact.setChecksum(this.scanner.getChecksum(file));
            if (this.transformArtifact(artifact)) {
                created.add(artifact);
                continue;
            }
            this.deleteJaredDirectory(artifact);
        }
        Collection uninstalledBundles = this.uninstall(deleted);
        Collection updatedBundles = this.update(modified);
        Collection installedBundles = this.install(created);
        HashSet toRefresh = new HashSet();
        toRefresh.addAll(uninstalledBundles);
        toRefresh.addAll(updatedBundles);
        toRefresh.addAll(installedBundles);
        this.findBundlesWithFragmentsToRefresh(toRefresh);
        this.findBundlesWithOptionalPackagesToRefresh(toRefresh);
        if (toRefresh.size() > 0) {
            this.refresh(toRefresh.toArray(new Bundle[toRefresh.size()]));
        }
        if (this.startBundles) {
            this.startAllBundles();
            this.delayedStart.addAll(installedBundles);
            this.delayedStart.removeAll(uninstalledBundles);
            this.startBundles(this.delayedStart);
        }
    }

    ArtifactListener findListener(File artifact, List listeners) {
        Iterator itL = listeners.iterator();
        while (itL.hasNext()) {
            ArtifactListener listener = (ArtifactListener)itL.next();
            if (!listener.canHandle(artifact)) continue;
            return listener;
        }
        return null;
    }

    boolean transformArtifact(Artifact artifact) {
        if (artifact.getListener() instanceof ArtifactTransformer) {
            this.prepareTempDir();
            try {
                File transformed = ((ArtifactTransformer)artifact.getListener()).transform(artifact.getJaredDirectory(), this.tmpDir);
                if (transformed != null) {
                    artifact.setTransformed(transformed);
                    return true;
                }
            }
            catch (Exception e) {
                this.log(2, "Unable to transform artifact: " + artifact.getPath().getAbsolutePath(), e);
            }
            return false;
        }
        if (artifact.getListener() instanceof ArtifactUrlTransformer) {
            try {
                URL url = artifact.getJaredUrl();
                URL transformed = ((ArtifactUrlTransformer)artifact.getListener()).transform(url);
                if (transformed != null) {
                    artifact.setTransformedUrl(transformed);
                    return true;
                }
            }
            catch (Exception e) {
                this.log(2, "Unable to transform artifact: " + artifact.getPath().getAbsolutePath(), e);
            }
            return false;
        }
        return true;
    }

    private void deleteTransformedFile(Artifact artifact) {
        if (artifact.getTransformed() != null && !artifact.getTransformed().equals(artifact.getPath()) && !artifact.getTransformed().delete()) {
            this.log(2, "Unable to delete transformed artifact: " + artifact.getTransformed().getAbsolutePath(), null);
        }
    }

    private void deleteJaredDirectory(Artifact artifact) {
        if (artifact.getJaredDirectory() != null && !artifact.getJaredDirectory().equals(artifact.getPath()) && !artifact.getJaredDirectory().delete()) {
            this.log(2, "Unable to delete jared artifact: " + artifact.getJaredDirectory().getAbsolutePath(), null);
        }
    }

    private void prepareTempDir() {
        if (this.tmpDir == null) {
            File f;
            if (!this.javaIoTmpdir.exists() && !this.javaIoTmpdir.mkdirs()) {
                throw new IllegalStateException("Unable to create temporary directory " + this.javaIoTmpdir);
            }
            while ((f = new File(this.javaIoTmpdir, "fileinstall-" + Long.toString(random.nextLong()))).exists() || !f.mkdirs()) {
            }
            this.tmpDir = f;
            this.tmpDir.deleteOnExit();
        } else {
            this.prepareDir(this.tmpDir);
        }
    }

    private void prepareDir(File dir) {
        if (!dir.exists() && !dir.mkdirs()) {
            this.log(1, "Cannot create folder " + dir + ". Is the folder write-protected?", null);
            throw new RuntimeException("Cannot create folder: " + dir);
        }
        if (!dir.isDirectory()) {
            this.log(1, "Cannot use " + dir + " because it's not a directory", null);
            throw new RuntimeException("Cannot start FileInstall using something that is not a directory");
        }
    }

    void log(int msgLevel, String message, Throwable e) {
        Util.log(this.context, this.logLevel, msgLevel, message, e);
    }

    boolean isFragment(Bundle bundle) {
        PackageAdmin padmin = FileInstall.getPackageAdmin();
        if (padmin != null) {
            return padmin.getBundleType(bundle) == 1;
        }
        return false;
    }

    void refresh(Bundle[] bundles) {
        FileInstall.refresh(bundles);
    }

    int getInt(Dictionary properties, String property, int dflt) {
        String value = (String)properties.get(property);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception e) {
                this.log(2, property + " set, but not a int: " + value, null);
            }
        }
        return dflt;
    }

    long getLong(Dictionary properties, String property, long dflt) {
        String value = (String)properties.get(property);
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (Exception e) {
                this.log(2, property + " set, but not a long: " + value, null);
            }
        }
        return dflt;
    }

    File getFile(Dictionary properties, String property, File dflt) {
        String value = (String)properties.get(property);
        if (value != null) {
            return new File(value);
        }
        return dflt;
    }

    boolean getBoolean(Dictionary properties, String property, boolean dflt) {
        String value = (String)properties.get(property);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return dflt;
    }

    public void close() {
        this.context.removeBundleListener((BundleListener)this);
        this.interrupt();
        Iterator iter = this.currentManagedArtifacts.values().iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            this.deleteTransformedFile(artifact);
            this.deleteJaredDirectory(artifact);
        }
        try {
            this.join(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void initializeCurrentManagedBundles() {
        Bundle[] bundles = this.context.getBundles();
        String watchedDirPath = this.watchedDirectory.toURI().normalize().getPath();
        HashMap<File, Long> checksums = new HashMap<File, Long>();
        for (int i = 0; i < bundles.length; ++i) {
            int index;
            String location = bundles[i].getLocation();
            String path = null;
            if (location != null && !location.equals("System Bundle")) {
                URI uri;
                try {
                    uri = new URI(bundles[i].getLocation()).normalize();
                }
                catch (URISyntaxException e) {
                    uri = new File(location).toURI().normalize();
                }
                path = uri.getPath();
            }
            if (path == null || (index = path.lastIndexOf(47)) == -1 || !path.startsWith(watchedDirPath)) continue;
            Artifact artifact = new Artifact();
            artifact.setBundleId(bundles[i].getBundleId());
            artifact.setChecksum(Util.loadChecksum(bundles[i], this.context));
            artifact.setListener(null);
            artifact.setPath(new File(path));
            this.currentManagedArtifacts.put(new File(path), artifact);
            checksums.put(new File(path), new Long(artifact.getChecksum()));
        }
        this.scanner.initialize(checksums);
    }

    private Collection install(Collection artifacts) {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        Iterator iter = artifacts.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            Bundle bundle = this.install(artifact);
            if (bundle == null) continue;
            bundles.add(bundle);
        }
        return bundles;
    }

    private Collection uninstall(Collection artifacts) {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        Iterator iter = artifacts.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            Bundle bundle = this.uninstall(artifact);
            if (bundle == null) continue;
            bundles.add(bundle);
        }
        return bundles;
    }

    private Collection update(Collection artifacts) {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        Iterator iter = artifacts.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            Bundle bundle = this.update(artifact);
            if (bundle == null) continue;
            bundles.add(bundle);
        }
        return bundles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bundle install(Artifact artifact) {
        File path = artifact.getPath();
        Bundle bundle = null;
        try {
            if (artifact.getListener() instanceof ArtifactInstaller) {
                ((ArtifactInstaller)artifact.getListener()).install(path);
            } else if (artifact.getListener() instanceof ArtifactUrlTransformer) {
                Artifact badArtifact = (Artifact)this.installationFailures.get(path);
                if (badArtifact != null && badArtifact.getChecksum() == artifact.getChecksum()) {
                    return null;
                }
                URL transformed = artifact.getTransformedUrl();
                String location = transformed.toString();
                BufferedInputStream in = new BufferedInputStream(transformed.openStream());
                try {
                    bundle = this.installOrUpdateBundle(location, in, artifact.getChecksum());
                }
                finally {
                    in.close();
                }
                artifact.setBundleId(bundle.getBundleId());
            } else if (artifact.getListener() instanceof ArtifactTransformer) {
                Artifact badArtifact = (Artifact)this.installationFailures.get(path);
                if (badArtifact != null && badArtifact.getChecksum() == artifact.getChecksum()) {
                    return null;
                }
                File transformed = artifact.getTransformed();
                String location = path.toURI().normalize().toString();
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(transformed != null ? transformed : path));
                try {
                    bundle = this.installOrUpdateBundle(location, in, artifact.getChecksum());
                }
                finally {
                    in.close();
                }
                artifact.setBundleId(bundle.getBundleId());
            }
            this.installationFailures.remove(path);
            this.currentManagedArtifacts.put(path, artifact);
            this.log(3, "Installed " + path, null);
        }
        catch (Exception e) {
            this.log(1, "Failed to install artifact: " + path, e);
            this.installationFailures.put(path, artifact);
        }
        return bundle;
    }

    private Bundle installOrUpdateBundle(String bundleLocation, BufferedInputStream is, long checksum) throws IOException, BundleException {
        is.mark(262144);
        JarInputStream jar = new JarInputStream(is);
        Manifest m = jar.getManifest();
        if (m == null) {
            throw new BundleException("The bundle " + bundleLocation + " does not have a META-INF/MANIFEST.MF! " + "Make sure, META-INF and MANIFEST.MF are the first 2 entries in your JAR!");
        }
        String sn = m.getMainAttributes().getValue("Bundle-SymbolicName");
        String vStr = m.getMainAttributes().getValue("Bundle-Version");
        Version v = vStr == null ? Version.emptyVersion : Version.parseVersion((String)vStr);
        Bundle[] bundles = this.context.getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            Version bv;
            Bundle b = bundles[i];
            if (b.getSymbolicName() == null || !b.getSymbolicName().equals(sn)) continue;
            vStr = (String)b.getHeaders().get("Bundle-Version");
            Version version = bv = vStr == null ? Version.emptyVersion : Version.parseVersion((String)vStr);
            if (!v.equals((Object)bv)) continue;
            is.reset();
            if (Util.loadChecksum(b, this.context) != checksum) {
                this.log(2, "A bundle with the same symbolic name (" + sn + ") and version (" + vStr + ") is already installed.  Updating this bundle instead.", null);
                this.stopTransient(b);
                Util.storeChecksum(b, checksum, this.context);
                b.update((InputStream)is);
            }
            return b;
        }
        is.reset();
        Bundle b = this.context.installBundle(bundleLocation, (InputStream)is);
        Util.storeChecksum(b, checksum, this.context);
        if (this.startLevel != 0) {
            FileInstall.getStartLevel().setBundleStartLevel(b, this.startLevel);
        }
        return b;
    }

    private Bundle uninstall(Artifact artifact) {
        Bundle bundle = null;
        try {
            File path = artifact.getPath();
            if (artifact.getListener() == null) {
                artifact.setListener(this.findListener(path, FileInstall.getListeners()));
            }
            this.currentManagedArtifacts.remove(path);
            this.deleteTransformedFile(artifact);
            if (artifact.getListener() instanceof ArtifactInstaller) {
                ((ArtifactInstaller)artifact.getListener()).uninstall(path);
            } else if (artifact.getBundleId() != 0L) {
                bundle = this.context.getBundle(artifact.getBundleId());
                if (bundle == null) {
                    this.log(2, "Failed to uninstall bundle: " + path + " with id: " + artifact.getBundleId() + ". The bundle has already been uninstalled", null);
                    return null;
                }
                this.log(4, "Uninstalling bundle " + bundle.getBundleId() + " (" + bundle.getSymbolicName() + ")", null);
                bundle.uninstall();
            }
            this.log(3, "Uninstalled " + path, null);
        }
        catch (Exception e) {
            this.log(2, "Failed to uninstall artifact: " + artifact.getPath(), e);
        }
        return bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bundle update(Artifact artifact) {
        Bundle bundle = null;
        try {
            File path = artifact.getPath();
            if (artifact.getListener() instanceof ArtifactInstaller) {
                ((ArtifactInstaller)artifact.getListener()).update(path);
            } else {
                if (artifact.getListener() instanceof ArtifactUrlTransformer) {
                    URL transformed = artifact.getTransformedUrl();
                    bundle = this.context.getBundle(artifact.getBundleId());
                    if (bundle == null) {
                        this.log(2, "Failed to update bundle: " + path + " with ID " + artifact.getBundleId() + ". The bundle has been uninstalled", null);
                        return null;
                    }
                    this.stopTransient(bundle);
                    Util.storeChecksum(bundle, artifact.getChecksum(), this.context);
                    InputStream in = transformed != null ? transformed.openStream() : new FileInputStream(path);
                    try {
                        bundle.update(in);
                    }
                    finally {
                        in.close();
                    }
                }
                if (artifact.getListener() instanceof ArtifactTransformer) {
                    File transformed = artifact.getTransformed();
                    bundle = this.context.getBundle(artifact.getBundleId());
                    if (bundle == null) {
                        this.log(2, "Failed to update bundle: " + path + " with ID " + artifact.getBundleId() + ". The bundle has been uninstalled", null);
                        return null;
                    }
                    this.stopTransient(bundle);
                    Util.storeChecksum(bundle, artifact.getChecksum(), this.context);
                    FileInputStream in = new FileInputStream(transformed != null ? transformed : path);
                    try {
                        bundle.update((InputStream)in);
                    }
                    finally {
                        ((InputStream)in).close();
                    }
                }
            }
            this.log(3, "Updated " + path, null);
        }
        catch (Throwable t) {
            this.log(2, "Failed to update artifact " + artifact.getPath(), t);
        }
        return bundle;
    }

    private void stopTransient(Bundle bundle) throws BundleException {
        if (this.startBundles && !this.isFragment(bundle)) {
            bundle.stop(1);
        }
    }

    private void startAllBundles() {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        Iterator it = this.currentManagedArtifacts.values().iterator();
        while (it.hasNext()) {
            Bundle bundle;
            Artifact artifact = (Artifact)it.next();
            if (artifact.getBundleId() <= 0L || (bundle = this.context.getBundle(artifact.getBundleId())) == null || bundle.getState() == 8 || bundle.getState() == 32 || !this.useStartTransient && !FileInstall.getStartLevel().isBundlePersistentlyStarted(bundle) || FileInstall.getStartLevel().getStartLevel() < FileInstall.getStartLevel().getBundleStartLevel(bundle)) continue;
            bundles.add(bundle);
        }
        this.startBundles(bundles);
    }

    private void startBundles(Collection bundles) {
        Iterator b = bundles.iterator();
        while (b.hasNext()) {
            if (!this.startBundle((Bundle)b.next())) continue;
            b.remove();
        }
    }

    private boolean startBundle(Bundle bundle) {
        StartLevel startLevelSvc = FileInstall.getStartLevel();
        if (this.startBundles && bundle.getState() != 1 && !this.isFragment(bundle) && startLevelSvc.getStartLevel() >= startLevelSvc.getBundleStartLevel(bundle)) {
            try {
                int options = this.useStartTransient ? 1 : 0;
                bundle.start(options |= this.useStartActivationPolicy ? 2 : 0);
                this.log(3, "Started bundle: " + bundle.getLocation(), null);
                return true;
            }
            catch (BundleException e) {
                this.log(2, "Error while starting bundle: " + bundle.getLocation(), e);
            }
        }
        return false;
    }

    protected void findBundlesWithFragmentsToRefresh(Set toRefresh) {
        HashSet<Bundle> fragments = new HashSet<Bundle>();
        Iterator iterator = toRefresh.iterator();
        while (iterator.hasNext()) {
            Clause[] clauses;
            String hostHeader;
            Bundle b = (Bundle)iterator.next();
            if (b.getState() == 1 || (hostHeader = (String)b.getHeaders().get("Fragment-Host")) == null || (clauses = Parser.parseHeader(hostHeader)) == null || clauses.length <= 0) continue;
            Clause path = clauses[0];
            Bundle[] bundles = this.context.getBundles();
            for (int i = 0; i < bundles.length; ++i) {
                Bundle hostBundle = bundles[i];
                if (!hostBundle.getSymbolicName().equals(path.getName())) continue;
                String ver = path.getAttribute("bundle-version");
                if (ver != null) {
                    VersionRange v = VersionRange.parseVersionRange(ver);
                    if (!v.contains(VersionTable.getVersion((String)hostBundle.getHeaders().get("Bundle-Version")))) continue;
                    fragments.add(hostBundle);
                    continue;
                }
                fragments.add(hostBundle);
            }
        }
        toRefresh.addAll(fragments);
    }

    protected void findBundlesWithOptionalPackagesToRefresh(Set toRefresh) {
        Bundle b;
        List importsList;
        HashSet<Bundle> bundles = new HashSet<Bundle>(Arrays.asList(this.context.getBundles()));
        bundles.removeAll(toRefresh);
        if (bundles.isEmpty()) {
            return;
        }
        HashMap<Bundle, List> imports = new HashMap<Bundle, List>();
        Iterator it = bundles.iterator();
        while (it.hasNext()) {
            Bundle b2 = (Bundle)it.next();
            String importsStr = (String)b2.getHeaders().get("Import-Package");
            importsList = this.getOptionalImports(importsStr);
            if (importsList.isEmpty()) {
                it.remove();
                continue;
            }
            imports.put(b2, importsList);
        }
        if (bundles.isEmpty()) {
            return;
        }
        ArrayList<Clause> exports = new ArrayList<Clause>();
        Iterator iterator = toRefresh.iterator();
        while (iterator.hasNext()) {
            String exportsStr;
            b = (Bundle)iterator.next();
            if (b.getState() == 1 || (exportsStr = (String)b.getHeaders().get("Export-Package")) == null) continue;
            Clause[] exportsList = Parser.parseHeader(exportsStr);
            exports.addAll(Arrays.asList(exportsList));
        }
        Iterator it2 = bundles.iterator();
        while (it2.hasNext()) {
            b = (Bundle)it2.next();
            importsList = (List)imports.get(b);
            Iterator itpi = importsList.iterator();
            while (itpi.hasNext()) {
                Clause pi = (Clause)itpi.next();
                boolean matching = false;
                Iterator itcl = exports.iterator();
                while (itcl.hasNext()) {
                    Version exported;
                    Clause pe = (Clause)itcl.next();
                    if (!pi.getName().equals(pe.getName())) continue;
                    String evStr = pe.getAttribute("version");
                    String ivStr = pi.getAttribute("version");
                    VersionRange imported = ivStr != null ? VersionRange.parseVersionRange(ivStr) : VersionRange.ANY_VERSION;
                    if (!imported.contains(exported = evStr != null ? Version.parseVersion((String)evStr) : Version.emptyVersion)) continue;
                    matching = true;
                    break;
                }
                if (matching) continue;
                itpi.remove();
            }
            if (!importsList.isEmpty()) continue;
            it2.remove();
        }
        toRefresh.addAll(bundles);
    }

    protected List getOptionalImports(String importsStr) {
        Clause[] imports = Parser.parseHeader(importsStr);
        LinkedList<Clause> result = new LinkedList<Clause>();
        for (int i = 0; i < imports.length; ++i) {
            String resolution = imports[i].getDirective("resolution");
            if (!"optional".equals(resolution)) continue;
            result.add(imports[i]);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ArtifactListener listener, long stamp) {
        if (this.updateWithListeners) {
            Iterator it = this.currentManagedArtifacts.values().iterator();
            while (it.hasNext()) {
                File path;
                Bundle bundle;
                Artifact artifact = (Artifact)it.next();
                if (artifact.getListener() != null || artifact.getBundleId() <= 0L || (bundle = this.context.getBundle(artifact.getBundleId())) == null || bundle.getLastModified() >= stamp || !listener.canHandle(path = artifact.getPath())) continue;
                Set set = this.processingFailures;
                synchronized (set) {
                    this.processingFailures.add(path);
                }
            }
        }
        DirectoryWatcher directoryWatcher = this;
        synchronized (directoryWatcher) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ArtifactListener listener) {
        Iterator it = this.currentManagedArtifacts.values().iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            if (artifact.getListener() != listener) continue;
            artifact.setListener(null);
        }
        DirectoryWatcher directoryWatcher = this;
        synchronized (directoryWatcher) {
            this.notifyAll();
        }
    }
}

