/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.action;

import java.awt.AWTEvent;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import nl.lxtreme.ols.client.ClientController;
import nl.lxtreme.ols.client.action.BaseAction;
import nl.lxtreme.ols.util.HostUtils;
import nl.lxtreme.ols.util.swing.SwingComponentUtils;
import nl.lxtreme.ols.util.swing.component.JErrorDialog;

public class ExportAction
extends BaseAction {
    private static final long serialVersionUID = 1L;
    private static final String ID = "ExportAction.";
    private static final Logger LOG = Logger.getLogger(ExportAction.class.getName());
    private final String exporterName;

    public ExportAction(ClientController aController, String aExporterName) {
        super(ExportAction.getID(aExporterName), aController, aExporterName, "Export the current diagram to a " + aExporterName + " file");
        this.exporterName = aExporterName;
    }

    public static final String getID(String aExporterName) {
        return ID.concat(aExporterName);
    }

    @Override
    public void actionPerformed(ActionEvent aEvent) {
        block5: {
            Window owner = SwingComponentUtils.getOwningWindow((AWTEvent)aEvent);
            ClientController controller = this.getController();
            if (!controller.hasCapturedData()) {
                JOptionPane.showMessageDialog(owner, "Nothing to export!", "Error", 0);
                return;
            }
            String[] extensions = controller.getExportExtensions(this.exporterName);
            String preferredExtension = extensions.length == 0 ? "" : extensions[0];
            File exportFileName = SwingComponentUtils.showFileSaveDialog((Window)owner, (FileFilter[])new FileFilter[]{new FileNameExtensionFilter("Valid export format(s)", extensions)});
            if (exportFileName != null) {
                File actualFile = HostUtils.setFileExtension((File)exportFileName, (String)preferredExtension);
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.info("Exporting capture data to file: " + actualFile);
                }
                try {
                    controller.exportTo(this.exporterName, actualFile);
                }
                catch (IOException exception) {
                    if (HostUtils.handleInterruptedException((Throwable)exception)) break block5;
                    LOG.log(Level.WARNING, "Export with '" + this.exporterName + "' failed!", exception);
                    JErrorDialog.showDialog((Window)owner, (String)"Export capture data failed!", (Throwable)exception);
                }
            }
        }
    }
}

