/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.tool.base;

import java.awt.AWTEvent;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import nl.lxtreme.ols.tool.base.ExportAware;
import nl.lxtreme.ols.tool.base.ToolDialog;
import nl.lxtreme.ols.util.HostUtils;
import nl.lxtreme.ols.util.swing.StandardActionFactory;
import nl.lxtreme.ols.util.swing.StdFileFilter;
import nl.lxtreme.ols.util.swing.SwingComponentUtils;

public class ToolUtils {
    public static JButton createCloseButton() {
        return StandardActionFactory.createCloseButton();
    }

    public static JButton createExportButton(ExportAware<?> aToolDialog) {
        ExportAction action = new ExportAction(aToolDialog);
        JButton exportButton = new JButton(action);
        SwingComponentUtils.registerKeystroke((JComponent)exportButton, (Action)action, (String)"EXPORT");
        return exportButton;
    }

    public static JButton createRunAnalysisButton(ToolDialog aToolDialog) {
        RunAnalysisAction action = new RunAnalysisAction(aToolDialog);
        JButton runButton = new JButton(action);
        SwingComponentUtils.registerKeystroke((JComponent)runButton, (Action)action, (String)"RUN-ANALYSIS");
        return runButton;
    }

    public static void setComboBoxIndex(JComboBox aComboBox, int aIndex) {
        int idx = aIndex;
        if (idx < 0) {
            idx = aComboBox.getSelectedIndex();
        } else if (idx > aComboBox.getItemCount()) {
            idx %= aComboBox.getItemCount();
        }
        aComboBox.setSelectedIndex(idx);
    }

    public static void showErrorMessage(Window aParent, String aMessage) {
        JOptionPane.showMessageDialog(aParent, aMessage, "Error ...", 0);
    }

    public static void showMessage(Window aParent, String aMessage) {
        JOptionPane.showMessageDialog(aParent, aMessage);
    }

    public static void showWarningMessage(Window aParent, String aMessage) {
        JOptionPane.showMessageDialog(aParent, aMessage, "Warning ...", 2);
    }

    static final class RunAnalysisAction
    extends AbstractAction
    implements RestorableAction {
        private static final long serialVersionUID = 1L;
        private final ToolDialog toolDialog;

        public RunAnalysisAction(ToolDialog aToolDialog) {
            super("Analyze");
            this.restore();
            this.toolDialog = aToolDialog;
        }

        @Override
        public void actionPerformed(ActionEvent aEvent) {
            String name = (String)this.getValue("Name");
            if ("Abort".equals(name)) {
                this.cancelToolTask();
                this.putValue("Name", "Analyze");
            } else if (this.startToolTask()) {
                this.putValue("Name", "Abort");
                this.putValue("ShortDescription", "Aborts current analysis...");
                this.putValue("AcceleratorKey", SwingComponentUtils.createMenuKeyMask((int)27, (int[])new int[0]));
            }
        }

        @Override
        public void restore() {
            this.putValue("Name", "Analyze");
            this.putValue("ShortDescription", "Run analysis");
            this.putValue("AcceleratorKey", SwingComponentUtils.createMenuKeyMask((int)10, (int[])new int[0]));
        }

        protected boolean cancelToolTask() {
            try {
                this.toolDialog.cancelTool();
                return true;
            }
            catch (IllegalStateException exception) {
                return false;
            }
        }

        protected boolean startToolTask() {
            try {
                return this.toolDialog.invokeTool();
            }
            catch (IllegalStateException exception) {
                return false;
            }
        }
    }

    static final class ExportAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private final ExportAware<?> toolDialog;

        public ExportAction(ExportAware<?> aToolDialog) {
            super("Export");
            this.toolDialog = aToolDialog;
            this.putValue("ShortDescription", "Exports the analysis results to file");
            this.putValue("AcceleratorKey", SwingComponentUtils.createMenuKeyMask((int)69, (int[])new int[0]));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent aEvent) {
            Window owner = SwingComponentUtils.getOwningWindow((AWTEvent)aEvent);
            File selectedFile = SwingComponentUtils.showFileSaveDialog((Window)owner, (FileFilter[])new FileFilter[]{StdFileFilter.CSV, StdFileFilter.HTML});
            if (selectedFile != null) {
                ExportAware.ExportFormat format = ExportAware.ExportFormat.CSV;
                String filenameExt = HostUtils.getFileExtension((File)selectedFile);
                if ("htm".equalsIgnoreCase(filenameExt) || "html".equalsIgnoreCase(filenameExt)) {
                    format = ExportAware.ExportFormat.HTML;
                }
                try {
                    this.toolDialog.exportToFile(selectedFile, format);
                }
                catch (IOException exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled() && this.toolDialog.getLastResult() != null;
        }
    }

    public static interface RestorableAction
    extends Action {
        public void restore();
    }
}

