/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.tool.dmx512;

import nl.lxtreme.ols.api.acquisition.AcquisitionResult;
import nl.lxtreme.ols.api.data.BaseDataSet;
import nl.lxtreme.ols.tool.dmx512.DMX512Data;
import nl.lxtreme.ols.tool.uart.AsyncSerialDataDecoder;

public class DMX512DataSet
extends BaseDataSet<DMX512Data> {
    public static final String EVENT_SBB = "Start before break";
    public static final String EVENT_MAB = "Mark after break";
    private int decodedSymbols;
    private int detectedErrors;
    private int symbolsBetweenMaB;
    private Boolean inMaB = Boolean.FALSE;

    public DMX512DataSet(int aStartOfDecodeIdx, int aEndOfDecodeIdx, AcquisitionResult aData) {
        super(aStartOfDecodeIdx, aEndOfDecodeIdx, aData);
    }

    public int getDecodedSymbols() {
        return this.decodedSymbols;
    }

    public int getDetectedErrors() {
        return this.detectedErrors;
    }

    public int getSlotCount() {
        return this.symbolsBetweenMaB - 1;
    }

    public void reportData(int aChannelIdx, int aStartSampleIdx, int aEndSampleIdx, int aSymbol) {
        int idx = this.size();
        ++this.decodedSymbols;
        if (Boolean.TRUE.equals(this.inMaB)) {
            ++this.symbolsBetweenMaB;
        }
        this.addData(new DMX512Data(idx, aChannelIdx, aStartSampleIdx, aEndSampleIdx, aSymbol));
    }

    public void reportError(int aChannelIdx, AsyncSerialDataDecoder.ErrorType aType, int aSampleIndex) {
        int idx = this.size();
        ++this.detectedErrors;
        this.addData(new DMX512Data(idx, aChannelIdx, aSampleIndex, aType));
    }

    public void reportEvent(int aChannelIdx, String aEvent, int aStartSampleIdx, int aEndSampleIdx) {
        int idx = this.size();
        if (EVENT_MAB.equals(aEvent)) {
            if (Boolean.FALSE.equals(this.inMaB)) {
                this.inMaB = Boolean.TRUE;
            } else if (Boolean.TRUE.equals(this.inMaB)) {
                this.inMaB = null;
            }
        }
        this.addData(new DMX512Data(idx, aChannelIdx, aStartSampleIdx, aEndSampleIdx, aEvent));
    }
}

