/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.io.socket;

import java.io.IOException;
import java.net.ServerSocket;
import javax.microedition.io.ServerSocketConnection;
import javax.microedition.io.StreamConnection;
import nl.lxtreme.ols.io.socket.SocketConnectionImpl;

final class ServerSocketConnectionImpl
implements ServerSocketConnection {
    private final ServerSocket socket;

    public ServerSocketConnectionImpl(ServerSocket aSocket) throws IllegalArgumentException {
        if (aSocket == null) {
            throw new IllegalArgumentException("Socket cannot be null!");
        }
        this.socket = aSocket;
    }

    @Override
    public StreamConnection acceptAndOpen() throws IOException {
        return new SocketConnectionImpl(this.socket.accept());
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }

    @Override
    public String getLocalAddress() throws IOException {
        return this.socket.getInetAddress().getHostAddress();
    }

    @Override
    public int getLocalPort() throws IOException {
        return this.socket.getLocalPort();
    }
}

