/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.io;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.microedition.io.Connection;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.StreamConnection;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.io.ConnectionFactory;
import org.osgi.service.io.ConnectorService;
import org.osgi.service.log.LogService;

public class ConnectorServiceImpl
implements ConnectorService {
    private final BundleContext context;
    private final List<Connection> openConnections;
    private volatile LogService logService;

    public ConnectorServiceImpl(BundleContext aContext) {
        this.context = aContext;
        this.openConnections = new ArrayList<Connection>();
    }

    static final String determineSchemeName(String aURI) {
        String protocol;
        block2: {
            protocol = null;
            try {
                URI uri = new URI(aURI);
                protocol = uri.getScheme();
            }
            catch (URISyntaxException exception) {
                int index = aURI.indexOf(58);
                if (index <= 0) break block2;
                protocol = aURI.substring(0, index);
            }
        }
        return protocol;
    }

    static final ConnectionFactory getConnectionFactory(BundleContext aContext, String aName) {
        String protocol = ConnectorServiceImpl.determineSchemeName(aName);
        if (protocol == null) {
            return null;
        }
        String filter = "(".concat("io.scheme").concat("=").concat(protocol).concat(")");
        try {
            ServiceReference[] serviceRefs = aContext.getAllServiceReferences(ConnectionFactory.class.getName(), filter);
            if (serviceRefs != null && serviceRefs.length > 0) {
                ConnectionFactory result = (ConnectionFactory)aContext.getService(serviceRefs[0]);
                return result;
            }
        }
        catch (InvalidSyntaxException exception) {
            throw new InternalError("Invalid service filter syntax?!");
        }
        return null;
    }

    public Connection open(String aName) throws IOException {
        return this.open(aName, 3);
    }

    public Connection open(String aName, int aMode) throws IOException {
        return this.open(aName, aMode, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection open(String aName, int aMode, boolean aTimeouts) throws IOException {
        ConnectionFactory cf = ConnectorServiceImpl.getConnectionFactory(this.context, aName);
        if (cf == null) {
            throw new ConnectionNotFoundException("No connection for: " + aName);
        }
        Connection connection = cf.createConnection(aName, aMode, aTimeouts);
        List<Connection> list = this.openConnections;
        synchronized (list) {
            this.openConnections.add(connection);
        }
        return connection;
    }

    public DataInputStream openDataInputStream(String aName) throws IOException {
        return new DataInputStream(this.openInputStream(aName));
    }

    public DataOutputStream openDataOutputStream(String aName) throws IOException {
        return new DataOutputStream(this.openOutputStream(aName));
    }

    public InputStream openInputStream(String aName) throws IOException {
        return this.openStreamConnection(aName).openInputStream();
    }

    public OutputStream openOutputStream(String aName) throws IOException {
        return this.openStreamConnection(aName).openOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ArrayList<Connection> connections;
        List<Connection> list = this.openConnections;
        synchronized (list) {
            connections = new ArrayList<Connection>(this.openConnections);
        }
        for (Connection conn : connections) {
            try {
                conn.close();
            }
            catch (IOException exception) {
                this.logService.log(4, "I/O exception closing connection!", (Throwable)exception);
            }
        }
    }

    private StreamConnection openStreamConnection(String aURI) throws IOException {
        Connection conn = this.open(aURI);
        if (!(conn instanceof StreamConnection)) {
            throw new IOException("Streaming connection not supported for this protocol!");
        }
        return (StreamConnection)conn;
    }
}

