/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.cmp;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.SwingConstants;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class MultipleAggregateIcon
implements Icon,
SwingConstants {
    protected int orientation;
    protected Icon[] icons;
    protected boolean[] visible;
    protected Rectangle[] lastPaintedRecs;

    public MultipleAggregateIcon(int numIcon, int orientation) {
        this.icons = new Icon[numIcon];
        this.visible = new boolean[numIcon];
        this.lastPaintedRecs = new Rectangle[numIcon];
        this.orientation = orientation;
        for (int i = 0; i < this.visible.length; ++i) {
            this.visible[i] = true;
        }
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        switch (this.orientation) {
            case 0: {
                int maxHeight = 0;
                for (int i = 0; i < this.visible.length; ++i) {
                    Icon icon;
                    int height;
                    if (!this.isVisibleAt(i) || (height = (icon = this.getIconAt(i)).getIconHeight()) <= maxHeight) continue;
                    maxHeight = height;
                }
                int xCursor = x;
                for (int i = 0; i < this.visible.length; ++i) {
                    if (this.isVisibleAt(i)) {
                        Icon icon = this.getIconAt(i);
                        int yCursor = y + (maxHeight - icon.getIconHeight()) / 2;
                        icon.paintIcon(c, g, xCursor, yCursor);
                        this.lastPaintedRecs[i] = new Rectangle(xCursor, yCursor, icon.getIconWidth(), icon.getIconHeight());
                        xCursor += icon.getIconWidth();
                        continue;
                    }
                    this.lastPaintedRecs[i] = null;
                }
                break;
            }
            case 1: {
                int maxWidth = 0;
                for (int i = 0; i < this.visible.length; ++i) {
                    Icon icon;
                    int width;
                    if (!this.isVisibleAt(i) || (width = (icon = this.getIconAt(i)).getIconWidth()) <= maxWidth) continue;
                    maxWidth = width;
                }
                int yCursor = y;
                for (int i = 0; i < this.visible.length; ++i) {
                    if (this.isVisibleAt(i)) {
                        Icon icon = this.getIconAt(i);
                        int xCursor = x + (maxWidth - icon.getIconWidth()) / 2;
                        icon.paintIcon(c, g, xCursor, yCursor);
                        this.lastPaintedRecs[i] = new Rectangle(xCursor, yCursor, icon.getIconWidth(), icon.getIconHeight());
                        yCursor += icon.getIconWidth();
                        continue;
                    }
                    this.lastPaintedRecs[i] = null;
                }
                break;
            }
        }
    }

    public int getIconWidth() {
        if (this.orientation == 0) {
            int width = 0;
            for (int i = 0; i < this.visible.length; ++i) {
                if (!this.visible[i]) continue;
                width += SwingUtil.getIconWidth(this.icons[i]);
            }
            return width;
        }
        int width = 0;
        for (int i = 0; i < this.visible.length; ++i) {
            int newWidth;
            if (!this.visible[i] || (newWidth = SwingUtil.getIconWidth(this.icons[i])) <= width) continue;
            width = newWidth;
        }
        return width;
    }

    public int getIconHeight() {
        if (this.orientation == 1) {
            int height = 0;
            for (int i = 0; i < this.visible.length; ++i) {
                if (!this.visible[i]) continue;
                height += SwingUtil.getIconHeight(this.icons[i]);
            }
            return height;
        }
        int height = 0;
        for (int i = 0; i < this.visible.length; ++i) {
            int newHeight;
            if (!this.visible[i] || (newHeight = SwingUtil.getIconHeight(this.icons[i])) <= height) continue;
            height = newHeight;
        }
        return height;
    }

    public int getSize() {
        return this.icons.length;
    }

    public Icon getIconAt(int index) {
        return this.icons[index];
    }

    public void setIconAt(int index, Icon icon) {
        this.icons[index] = icon;
    }

    public boolean isVisibleAt(int index) {
        return this.visible[index] && this.icons[index] != null;
    }

    public void setVisibleAt(int index, boolean visible) {
        this.visible[index] = visible;
    }

    public Rectangle getLastPaintedRecAt(int index) {
        return this.lastPaintedRecs[index];
    }
}

