/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.project.impl;

import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import nl.lxtreme.ols.api.data.Cursor;
import nl.lxtreme.ols.util.ColorUtils;

public class CursorImpl
implements Comparable<CursorImpl>,
Cursor {
    public static final int MAX_CURSORS = 10;
    private final PropertyChangeSupport propertyChangeSupport;
    private final int index;
    private String label;
    private Long timestamp;
    private Color color;

    public CursorImpl(Cursor aCursor, long aAbsLen) {
        this(aCursor.getIndex());
        this.color = aCursor.getColor();
        this.label = aCursor.getLabel();
        this.timestamp = aCursor.isDefined() && aCursor.getTimestamp() <= aAbsLen ? Long.valueOf(aCursor.getTimestamp()) : null;
    }

    public CursorImpl(int aIndex) {
        if (aIndex < 0 || aIndex >= 10) {
            throw new IllegalArgumentException("Invalid cursor index!");
        }
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.index = aIndex;
        this.color = ColorUtils.parseColor((String)"7bf9dd").brighter();
    }

    public CursorImpl(int aIndex, long aTimestamp) {
        this(aIndex);
        this.timestamp = aTimestamp;
    }

    public CursorImpl(int aIndex, Long aTimestamp) {
        this(aIndex);
        this.timestamp = aTimestamp;
    }

    public void addPropertyChangeListener(PropertyChangeListener aListener) {
        this.propertyChangeSupport.addPropertyChangeListener(aListener);
    }

    public void clear() {
        this.timestamp = null;
    }

    public Cursor clone() {
        try {
            Cursor result = (Cursor)super.clone();
            if (this.isDefined()) {
                result.setTimestamp(this.timestamp.longValue());
            }
            if (this.hasLabel()) {
                result.setLabel(new String(this.label));
            }
            result.setColor(this.color);
            return result;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException("Internal error: Object#clone() not supported?!");
        }
    }

    @Override
    public int compareTo(CursorImpl aOtherCursor) {
        return this.index - aOtherCursor.index;
    }

    public boolean equals(Object aObject) {
        if (this == aObject) {
            return true;
        }
        if (aObject == null || this.getClass() != aObject.getClass()) {
            return false;
        }
        CursorImpl other = (CursorImpl)aObject;
        return this.index == other.index;
    }

    public Color getColor() {
        return this.color;
    }

    public int getIndex() {
        return this.index;
    }

    public String getLabel() {
        return this.label;
    }

    public long getTimestamp() {
        if (this.timestamp == null) {
            throw new IllegalStateException("Cannot get timestamp on undefined cursor!");
        }
        return this.timestamp;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.index;
        return result;
    }

    public boolean hasLabel() {
        return this.label != null && !this.label.trim().isEmpty();
    }

    public boolean inArea(long aTimestamp, double aDelta) {
        if (!this.isDefined()) {
            return false;
        }
        double min = (double)this.timestamp.longValue() - aDelta;
        double max = (double)this.timestamp.longValue() + aDelta;
        return (double)aTimestamp >= min && (double)aTimestamp <= max;
    }

    public boolean isDefined() {
        return this.timestamp != null;
    }

    public void removePropertyChangeListener(PropertyChangeListener aListener) {
        this.propertyChangeSupport.removePropertyChangeListener(aListener);
    }

    public void setColor(Color aColor) {
        if (aColor == null) {
            throw new IllegalArgumentException("Parameter color cannot be null!");
        }
        Color oldColor = this.color;
        this.color = aColor;
        this.propertyChangeSupport.fireIndexedPropertyChange("cursorColor", this.index, oldColor, this.color);
    }

    public void setLabel(String aLabel) {
        String oldLabel = this.label;
        this.label = aLabel;
        this.propertyChangeSupport.fireIndexedPropertyChange("cursorLabel", this.index, oldLabel, this.label);
    }

    public void setTimestamp(long aTimestamp) {
        Long oldValue = this.timestamp;
        this.timestamp = aTimestamp;
        this.propertyChangeSupport.fireIndexedPropertyChange("cursorTimestamp", this.index, oldValue, this.timestamp);
    }

    public String toString() {
        return this.index + ": " + this.label;
    }
}

