/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.project.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import nl.lxtreme.ols.api.UserSettings;
import nl.lxtreme.ols.api.data.project.Project;
import nl.lxtreme.ols.api.data.project.ProjectVisitor;
import nl.lxtreme.ols.api.data.project.UserSettingsManager;
import nl.lxtreme.ols.util.HostUtils;
import org.osgi.service.log.LogService;

public final class UserSettingsManagerImpl
implements UserSettingsManager {
    private static final String SETTINGS_ID_FILENAME = "settings.";
    private volatile LogService log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadUserSettings(File aUserSettingsFile, Project aProject) {
        if (aUserSettingsFile == null) {
            throw new IllegalArgumentException("User settings file cannot be null!");
        }
        if (aProject == null) {
            throw new IllegalArgumentException("Project cannot be null!");
        }
        if (!aUserSettingsFile.exists()) {
            this.log.log(3, "Ignoring user settings from " + aUserSettingsFile + "; file does not exist...");
            return;
        }
        this.log.log(3, "Loading user settings from " + aUserSettingsFile);
        BufferedInputStream is = null;
        ZipInputStream zipIS = null;
        try {
            is = new BufferedInputStream(new FileInputStream(aUserSettingsFile));
            zipIS = new ZipInputStream(is);
            ZipEntry ze = null;
            while ((ze = zipIS.getNextEntry()) != null) {
                String userSettingsName = ze.getName();
                if (userSettingsName.startsWith(SETTINGS_ID_FILENAME)) continue;
                Properties settings = new Properties();
                settings.load(zipIS);
                UserSettings userSettings = aProject.getSettings(userSettingsName);
                userSettings.putAll((Map)settings);
                zipIS.closeEntry();
            }
        }
        catch (IOException exception) {
            try {
                this.log.log(2, "Failed to load implicit user settings...", (Throwable)exception);
            }
            catch (Throwable throwable) {
                HostUtils.closeResource(zipIS);
                HostUtils.closeResource(is);
                throw throwable;
            }
            HostUtils.closeResource(zipIS);
            HostUtils.closeResource((Closeable)is);
        }
        HostUtils.closeResource((Closeable)zipIS);
        HostUtils.closeResource((Closeable)is);
    }

    public void saveUserSettings(File aUserSettingsFile, Project aProject) {
        if (aUserSettingsFile == null) {
            throw new IllegalArgumentException("User settings file cannot be null!");
        }
        if (aProject == null) {
            throw new IllegalArgumentException("Project cannot be null!");
        }
        this.log.log(3, "Saving user settings to " + aUserSettingsFile);
        BufferedOutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(aUserSettingsFile));
            final ZipOutputStream zipOS = new ZipOutputStream(os);
            ZipEntry zipEntry = new ZipEntry(SETTINGS_ID_FILENAME + System.currentTimeMillis());
            zipOS.putNextEntry(zipEntry);
            aProject.visit(new ProjectVisitor(){

                public void visit(UserSettings aSettings) throws IOException {
                    ZipEntry zipEntry = new ZipEntry(aSettings.getName());
                    zipOS.putNextEntry(zipEntry);
                    Properties props = new Properties();
                    for (Map.Entry userSetting : aSettings) {
                        props.put(userSetting.getKey(), userSetting.getValue());
                    }
                    props.store(zipOS, aSettings.getName().concat(" settings"));
                }
            });
            zipOS.flush();
            zipOS.close();
        }
        catch (IOException exception) {
            try {
                this.log.log(2, "Failed to save implicit user settings...", (Throwable)exception);
                throw new RuntimeException("Failed to save implicit user settings.", exception);
            }
            catch (Throwable throwable) {
                HostUtils.closeResource(os);
                throw throwable;
            }
        }
        HostUtils.closeResource((Closeable)os);
    }

    public void setLog(LogService aLog) {
        this.log = aLog;
    }
}

