/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.project.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.List;
import nl.lxtreme.ols.api.acquisition.AcquisitionResult;
import nl.lxtreme.ols.api.data.Channel;
import nl.lxtreme.ols.api.data.Cursor;
import nl.lxtreme.ols.api.data.DataSet;
import nl.lxtreme.ols.client.project.impl.ChannelImpl;
import nl.lxtreme.ols.client.project.impl.CursorImpl;
import nl.lxtreme.ols.client.project.impl.ProjectProperties;

public class DataSetImpl
implements PropertyChangeListener,
DataSet,
ProjectProperties {
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private final AcquisitionResult capturedData;
    private final Cursor[] cursors;
    private final Channel[] channels;
    private boolean cursorsEnabled;

    public DataSetImpl(AcquisitionResult aCapturedData, DataSet aOld, boolean aRetainAnnotations) {
        this.capturedData = aCapturedData;
        this.cursorsEnabled = aOld.isCursorsEnabled();
        this.channels = this.createChannels(aCapturedData.getChannels(), aCapturedData.getEnabledChannels(), aRetainAnnotations, aOld.getChannels());
        this.cursors = this.createCursors(10, aOld.getCursors());
    }

    DataSetImpl() {
        this.capturedData = null;
        this.cursors = this.createCursors(10, new Cursor[0]);
        this.channels = this.createChannels(32, -1, false, new Channel[0]);
        this.cursorsEnabled = true;
    }

    public void addPropertyChangeListener(PropertyChangeListener aListener) {
        this.propertyChangeSupport.addPropertyChangeListener(aListener);
    }

    public AcquisitionResult getCapturedData() {
        return this.capturedData;
    }

    public Channel getChannel(int aIndex) {
        Channel channel = this.channels[aIndex];
        if (channel == null) {
            this.channels[aIndex] = channel = new ChannelImpl(aIndex);
        }
        return channel;
    }

    public Channel[] getChannels() {
        return Arrays.copyOf(this.channels, this.channels.length);
    }

    public Cursor getCursor(int aIndex) {
        return this.cursors[aIndex];
    }

    public Cursor[] getCursors() {
        return Arrays.copyOf(this.cursors, this.cursors.length);
    }

    public boolean isCursorsEnabled() {
        return this.cursorsEnabled;
    }

    @Override
    public void propertyChange(PropertyChangeEvent aEvent) {
        this.propertyChangeSupport.firePropertyChange(aEvent);
    }

    public void removePropertyChangeListener(PropertyChangeListener aListener) {
        this.propertyChangeSupport.removePropertyChangeListener(aListener);
    }

    public void setCursorsEnabled(boolean aEnabled) {
        boolean old = this.cursorsEnabled;
        this.cursorsEnabled = aEnabled;
        this.propertyChangeSupport.firePropertyChange("cursorsEnabled", old, aEnabled);
    }

    final void mergeChannelLabels(List<String> aLabels) {
        if (aLabels == null) {
            return;
        }
        int channelCount = Math.min(aLabels.size(), this.channels.length);
        for (int i = 0; i < channelCount; ++i) {
            Channel channel = this.channels[i];
            if (channel == null) continue;
            channel.setLabel(aLabels.get(i));
        }
    }

    private Channel[] createChannels(int aCount, int aMask, boolean aRetainAnnotations, Channel ... aInitialValues) {
        int chCount = this.capturedData == null ? aCount : this.capturedData.getChannels();
        Channel[] result = new Channel[aCount];
        int j = 0;
        for (int i = 0; j < aCount && i < 32; ++i) {
            int mask = 1 << i;
            if ((aMask & mask) == 0) continue;
            ChannelImpl channel = j < aInitialValues.length && j < chCount && aInitialValues[j] != null && aInitialValues[j].getIndex() == i ? new ChannelImpl(aInitialValues[j], aRetainAnnotations) : new ChannelImpl(i);
            channel.addPropertyChangeListener(this);
            result[j++] = channel;
        }
        return result;
    }

    private Cursor[] createCursors(int aCount, Cursor ... aInitialValues) {
        long absLen = this.capturedData == null ? 0L : this.capturedData.getAbsoluteLength();
        Cursor[] result = new Cursor[aCount];
        for (int i = 0; i < aCount; ++i) {
            CursorImpl cursor = i < aInitialValues.length ? new CursorImpl(aInitialValues[i], absLen) : new CursorImpl(i);
            cursor.addPropertyChangeListener(this);
            result[i] = cursor;
        }
        return result;
    }
}

