/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay.util;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ClickableLink
extends JLabel {
    private static final long serialVersionUID = 1L;
    private final Object linkId;
    private MouseListener mouseListener;
    private volatile LinkListener linkListener;

    public ClickableLink(String aText, Object aLinkId) {
        super(aText);
        this.linkId = aLinkId;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent aEvent) {
                if (ClickableLink.this.isEnabled() && !aEvent.isConsumed()) {
                    ClickableLink.this.invokeLinkListener();
                }
            }

            @Override
            public void mouseEntered(MouseEvent aEvent) {
                if (ClickableLink.this.isEnabled()) {
                    aEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                }
            }

            @Override
            public void mouseExited(MouseEvent aEvent) {
                if (ClickableLink.this.isEnabled()) {
                    aEvent.getComponent().setCursor(Cursor.getDefaultCursor());
                }
            }
        };
        this.addMouseListener(this.mouseListener);
    }

    @Override
    public void removeNotify() {
        this.removeMouseListener(this.mouseListener);
        this.mouseListener = null;
        super.removeNotify();
    }

    public void setLinkListener(LinkListener aListener) {
        this.linkListener = aListener;
    }

    final void invokeLinkListener() {
        if (this.linkListener != null) {
            this.linkListener.linkActivated(this.linkId);
        }
    }

    @Override
    protected void paintComponent(Graphics aCanvas) {
        Rectangle rect = this.getVisibleRect();
        Font f = this.getFont();
        FontMetrics fm = aCanvas.getFontMetrics(f);
        String text = this.getText();
        int tw = SwingUtilities.computeStringWidth(fm, text);
        int x1 = rect.x;
        int x2 = x1 + tw - 1;
        int y1 = rect.y + fm.getAscent();
        int y2 = y1 + fm.getDescent() - 1;
        Color fontColor = this.isEnabled() ? this.getForeground() : UIManager.getColor("Button.disabledText");
        aCanvas.setColor(fontColor);
        aCanvas.drawString(text, x1, y1);
        if (this.isEnabled()) {
            aCanvas.drawLine(x1, y2, x2, y2);
        }
    }

    public static interface LinkListener {
        public void linkActivated(Object var1);
    }
}

