/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay.signalelement;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.UIManager;
import nl.lxtreme.ols.client.signaldisplay.signalelement.SignalElement;

public class ElementGroup {
    private final List<SignalElement> elements;
    private final int index;
    private int mask;
    private String name;
    private String summaryLabel;
    private String analogSignalLabel;
    private boolean visible;
    private int viewOptions;

    ElementGroup(int aIndex, String aName) {
        if (aName == null || aName.trim().isEmpty()) {
            throw new IllegalArgumentException("Name cannot be null or empty!");
        }
        this.index = aIndex;
        this.name = aName;
        this.mask = 0;
        this.visible = true;
        this.viewOptions = ChannelElementType.DIGITAL_SIGNAL.mask;
        if (UIManager.getBoolean("ols.analogscope.default.visible.boolean")) {
            this.viewOptions |= ChannelElementType.ANALOG_SIGNAL.mask;
        }
        if (UIManager.getBoolean("ols.groupsummary.default.visible.boolean")) {
            this.viewOptions |= ChannelElementType.GROUP_SUMMARY.mask;
        }
        this.elements = new ArrayList<SignalElement>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addElement(SignalElement aElement) {
        if (this.hasElement(aElement)) {
            return;
        }
        SignalElement signalElement = aElement;
        ElementGroup oldGroup = aElement.getGroup();
        if (oldGroup != null) {
            oldGroup.removeElement(signalElement);
        }
        List<SignalElement> list = this.elements;
        synchronized (list) {
            this.elements.add(signalElement);
            signalElement.setGroup(this);
            this.mask |= aElement.getMask();
        }
    }

    public boolean equals(Object aObject) {
        if (this == aObject) {
            return true;
        }
        if (aObject == null || !(aObject instanceof ElementGroup)) {
            return false;
        }
        ElementGroup other = (ElementGroup)aObject;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String getAnalogSignalLabel() {
        if (this.analogSignalLabel == null || this.analogSignalLabel.trim().isEmpty()) {
            return this.getDefaultAnalogSignalName();
        }
        return this.analogSignalLabel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignalElement getChannelByIndex(int aChannelIndex) {
        List<SignalElement> list = this.elements;
        synchronized (list) {
            for (SignalElement element : this.elements) {
                if (!element.isDigitalSignal() || element.getChannel().getIndex() != aChannelIndex) continue;
                return element;
            }
        }
        return null;
    }

    public Color getColor() {
        Color result = UIManager.getColor(this.getColorKey());
        if (result == null) {
            result = Color.WHITE;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getElementCount() {
        List<SignalElement> list = this.elements;
        synchronized (list) {
            return this.elements.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getElementCount(SignalElement.SignalElementType aType) {
        int count = 0;
        List<SignalElement> list = this.elements;
        synchronized (list) {
            for (SignalElement element : this.elements) {
                if (!aType.equals((Object)element.getType())) continue;
                ++count;
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<SignalElement> getElements() {
        ArrayList<SignalElement> result = new ArrayList<SignalElement>();
        List<SignalElement> list = this.elements;
        synchronized (list) {
            result.addAll(this.elements);
        }
        return result;
    }

    public String getGroupSummaryLabel() {
        if (this.summaryLabel == null || this.summaryLabel.trim().isEmpty()) {
            return this.getDefaultGroupSummaryName();
        }
        return this.summaryLabel;
    }

    public int getIndex() {
        return this.index;
    }

    public int getMask() {
        return this.mask;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasElement(SignalElement aElement) {
        if (aElement == null) {
            throw new IllegalArgumentException("Channel cannot be null!");
        }
        return this.elements.contains(aElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasElements() {
        List<SignalElement> list = this.elements;
        synchronized (list) {
            return !this.elements.isEmpty();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean isShowAnalogSignal() {
        return (this.viewOptions & ChannelElementType.ANALOG_SIGNAL.getMask()) != 0;
    }

    public boolean isShowDigitalSignals() {
        return (this.viewOptions & ChannelElementType.DIGITAL_SIGNAL.getMask()) != 0;
    }

    public boolean isShowGroupSummary() {
        return (this.viewOptions & ChannelElementType.GROUP_SUMMARY.getMask()) != 0;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setAnalogSignalLabel(String aSignalLabel) {
        this.analogSignalLabel = aSignalLabel;
    }

    public void setColor(Color aColor) {
        if (aColor == null) {
            throw new IllegalArgumentException("Color cannot be null!");
        }
        UIManager.put(this.getColorKey(), aColor);
    }

    public void setGroupSummaryLabel(String aSummaryLabel) {
        this.summaryLabel = aSummaryLabel;
    }

    public void setName(String aName) {
        if (aName == null || aName.trim().isEmpty()) {
            throw new IllegalArgumentException("Name cannot be null or empty!");
        }
        this.name = aName;
    }

    public void setShowAnalogSignal(boolean aShowAnalogSignal) {
        int mask = ChannelElementType.ANALOG_SIGNAL.getMask();
        this.viewOptions = aShowAnalogSignal ? (this.viewOptions |= mask) : (this.viewOptions &= ~mask);
    }

    public void setShowDigitalSignals(boolean aShowDigitalSignals) {
        int mask = ChannelElementType.DIGITAL_SIGNAL.getMask();
        this.viewOptions = aShowDigitalSignals ? (this.viewOptions |= mask) : (this.viewOptions &= ~mask);
    }

    public void setShowGroupSummary(boolean aShowSummary) {
        int mask = ChannelElementType.GROUP_SUMMARY.getMask();
        this.viewOptions = aShowSummary ? (this.viewOptions |= mask) : (this.viewOptions &= ~mask);
    }

    public void setVisible(boolean aVisible) {
        this.visible = aVisible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int getVirtualIndex(SignalElement aElement) {
        Iterator<SignalElement> iter;
        List<SignalElement> list = this.elements;
        synchronized (list) {
            iter = this.elements.iterator();
        }
        int i = 0;
        while (iter.hasNext()) {
            if (aElement == iter.next()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void moveChannel(SignalElement aElement, int aNewIndex) {
        ElementGroup oldGroup = aElement.getGroup();
        if (oldGroup != null) {
            oldGroup.removeElement(aElement);
        }
        List<SignalElement> list = this.elements;
        synchronized (list) {
            if (aNewIndex >= this.elements.size()) {
                this.elements.add(aElement);
            } else {
                this.elements.add(Math.max(0, aNewIndex), aElement);
            }
            aElement.setGroup(this);
            this.mask |= aElement.getMask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeElement(SignalElement aElement) {
        List<SignalElement> list = this.elements;
        synchronized (list) {
            if (this.elements.remove(aElement)) {
                aElement.setGroup(null);
                this.mask &= ~aElement.getMask();
            }
        }
    }

    private String getColorKey() {
        return String.format("ols.channelgroup%d.default.color", this.index % 4 + 1);
    }

    private String getDefaultAnalogSignalName() {
        return String.format("Scope-%d", this.getIndex() + 1);
    }

    private String getDefaultGroupSummaryName() {
        return String.format("Summary-%d", this.getIndex() + 1);
    }

    public static enum ChannelElementType {
        DIGITAL_SIGNAL(1),
        GROUP_SUMMARY(2),
        ANALOG_SIGNAL(4);

        private int mask;

        private ChannelElementType(int aValue) {
            this.mask = 1 << aValue;
        }

        public int getMask() {
            return this.mask;
        }
    }
}

