/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.signaldisplay.action;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import nl.lxtreme.ols.api.data.Channel;
import nl.lxtreme.ols.client.signaldisplay.SignalDiagramComponent;
import nl.lxtreme.ols.client.signaldisplay.SignalDiagramController;
import nl.lxtreme.ols.client.signaldisplay.signalelement.SignalElement;

public class RemoveChannelAnnotations
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private final SignalElement signalElement;
    private final SignalDiagramController controller;

    public RemoveChannelAnnotations(SignalDiagramController aController, SignalElement aSignalElement) {
        super("Remove annotations");
        this.controller = aController;
        this.signalElement = aSignalElement;
        this.setEnabled(this.signalElement != null && this.signalElement.isDigitalSignal());
    }

    @Override
    public void actionPerformed(ActionEvent aEvent) {
        this.getChannel().clearAnnotations();
        this.getSignalDiagram().repaintSignalElement(this.signalElement);
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled() && this.hasAnnotations();
    }

    private Channel getChannel() {
        return this.signalElement.getChannel();
    }

    private SignalDiagramComponent getSignalDiagram() {
        return this.controller.getSignalDiagram();
    }

    private boolean hasAnnotations() {
        return !this.getChannel().getAnnotations().isEmpty();
    }
}

