/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.client.action;

import java.awt.AWTEvent;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import nl.lxtreme.ols.client.ClientController;
import nl.lxtreme.ols.client.action.BaseAction;
import nl.lxtreme.ols.util.HostUtils;
import nl.lxtreme.ols.util.swing.SwingComponentUtils;
import nl.lxtreme.ols.util.swing.component.JErrorDialog;

public class OpenDataFileAction
extends BaseAction {
    private static final Logger LOG = Logger.getLogger(OpenDataFileAction.class.getName());
    private static final long serialVersionUID = 1L;
    public static final String ID = "OpenDataFile";
    public static final String OLS_FILE_EXTENSION = "ols";
    public static final FileFilter OLS_FILEFILTER = new FileNameExtensionFilter("OpenLogic Sniffer data file", "ols");

    public OpenDataFileAction(ClientController aController) {
        super(ID, aController, "document-open.png", "Open ...", "Open an existing data file");
        this.putValue("MnemonicKey", 79);
    }

    @Override
    public void actionPerformed(ActionEvent aEvent) {
        block3: {
            Window owner = SwingComponentUtils.getOwningWindow((AWTEvent)aEvent);
            File file = SwingComponentUtils.showFileOpenDialog((Window)owner, (FileFilter[])new FileFilter[]{OLS_FILEFILTER});
            if (file != null) {
                LOG.log(Level.INFO, "Loading capture data from file {0}", file);
                try {
                    this.getController().openDataFile(file);
                }
                catch (IOException exception) {
                    if (HostUtils.handleInterruptedException((Throwable)exception)) break block3;
                    LOG.log(Level.WARNING, "Loading OLS file failed!", exception);
                    JErrorDialog.showDialog((Window)owner, (String)"Loading the capture data failed!", (Throwable)exception);
                }
            }
        }
    }
}

