/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.util.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.util.List;

public class ArrayFocusTravelPolicy
extends FocusTraversalPolicy {
    private final Component[] components;

    public ArrayFocusTravelPolicy(Component ... aComponents) {
        this.components = aComponents;
    }

    public ArrayFocusTravelPolicy(List<Component> aComponents) {
        this.components = aComponents.toArray(new Component[aComponents.size()]);
    }

    @Override
    public Component getComponentAfter(Container container, Component component) {
        return this.cycle(component, 1);
    }

    @Override
    public Component getComponentBefore(Container container, Component component) {
        return this.cycle(component, -1);
    }

    @Override
    public Component getDefaultComponent(Container container) {
        return this.getFirstComponent(container);
    }

    @Override
    public Component getFirstComponent(Container container) {
        return this.components[0];
    }

    @Override
    public Component getLastComponent(Container container) {
        return this.components[this.components.length - 1];
    }

    private Component cycle(Component aLastComponent, int aDelta) {
        int size = this.components.length;
        int index = this.findIndexFromComponent(aLastComponent);
        if (index < 0) {
            return null;
        }
        int newIndex = (size + index + aDelta) % size;
        return this.components[newIndex];
    }

    private int findIndexFromComponent(Component aComponent) {
        int size = this.components.length;
        for (int i = 0; i < size; ++i) {
            Component currentC = this.components[i];
            if (currentC != aComponent) continue;
            return i;
        }
        return -1;
    }
}

