/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.util.export;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Logger;
import nl.lxtreme.ols.util.ExportUtils;

public class CsvExporterImpl
implements ExportUtils.CsvExporter {
    private static final Logger LOG = Logger.getAnonymousLogger();
    private final char delimiter;
    private BufferedWriter writer;
    private int headerCount = -1;

    public CsvExporterImpl(File aFile) throws IOException {
        this(aFile, ',');
    }

    public CsvExporterImpl(File aFile, char aDelimiter) throws IOException {
        this.writer = new BufferedWriter(new FileWriter(aFile));
        this.delimiter = aDelimiter;
    }

    @Override
    public void addRow(Object ... aValues) throws IOException {
        if (aValues.length != this.headerCount) {
            LOG.warning("Number of cells not equal to header count! Header count = " + this.headerCount + ", cell count = " + aValues.length);
        }
        int length = Math.max(Math.min(this.headerCount, aValues.length), this.headerCount);
        for (int i = 0; i < length; ++i) {
            Object value = i < aValues.length ? aValues[i] : null;
            this.writer.append(this.quote(value));
            if (i >= length - 1) continue;
            this.writer.append(this.delimiter);
        }
        this.writer.newLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.writer.flush();
        }
        finally {
            this.writer.close();
            this.writer = null;
        }
    }

    @Override
    public void setHeaders(String ... aHeaders) throws IOException {
        this.headerCount = aHeaders.length;
        for (int i = 0; i < aHeaders.length; ++i) {
            this.writer.append(this.quote(aHeaders[i]));
            if (i >= aHeaders.length - 1) continue;
            this.writer.append(this.delimiter);
        }
        this.writer.newLine();
    }

    private String quote(Object aValue) {
        String value = aValue == null ? "" : (aValue instanceof Character ? (Character.isLetterOrDigit(((Character)aValue).charValue()) ? String.valueOf(aValue) : "") : String.valueOf(aValue));
        return "\"" + value + "\"";
    }
}

