/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.animation;

import java.awt.Component;
import java.awt.Rectangle;
import org.noos.xing.mydoggy.plaf.ui.animation.AbstractAnimation;

public class MoveComponentAnimation
extends AbstractAnimation {
    protected Rectangle startBounds;
    protected Rectangle endBounds;
    protected Component component;
    protected int deltaX;
    protected int deltaY;
    protected int deltaWidth;
    protected int deltaHeight;

    public MoveComponentAnimation(float animationDuration, Component component) {
        super(animationDuration);
        this.component = component;
    }

    protected void onShow(Object ... params) {
        this.endBounds = (Rectangle)params[0];
    }

    protected void onHide(Object ... params) {
    }

    protected void onStartAnimation(AbstractAnimation.Direction direction) {
        this.startBounds = this.component.getBounds();
        this.deltaX = this.endBounds.x - this.startBounds.x;
        this.deltaY = this.endBounds.y - this.startBounds.y;
        this.deltaWidth = this.endBounds.width - this.startBounds.width;
        this.deltaHeight = this.endBounds.height - this.startBounds.height;
    }

    protected void onFinishAnimation() {
        this.component.setBounds(this.endBounds);
    }

    protected float onAnimating(float animationPercent) {
        int offsetX = (int)(animationPercent * (float)this.deltaX);
        int offsetY = (int)(animationPercent * (float)this.deltaY);
        int offsetWidth = (int)(animationPercent * (float)this.deltaWidth);
        int offsetHeight = (int)(animationPercent * (float)this.deltaHeight);
        Rectangle newBounds = new Rectangle(this.startBounds.x + offsetX, this.startBounds.y + offsetY, this.startBounds.width + offsetWidth, this.startBounds.height + offsetHeight);
        this.component.setBounds(newBounds);
        return animationPercent;
    }
}

