/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.api.util;

public enum UnitOfTime {
    S("", 1.0),
    MS("m", 0.001),
    US("\u03bc", 1.0E-6),
    NS("n", 1.0E-9),
    PS("p", 1.0E-12),
    FS("f", 1.0E-15);

    public static final double ZERO_THRESHOLD = 1.0E-16;
    private static final String BASE_UNIT = "s";
    private final String displayName;
    private final double factor;

    private UnitOfTime(String aPrefix, double aFactor) {
        this.displayName = aPrefix.concat(BASE_UNIT);
        this.factor = aFactor;
    }

    public static String format(double aTime) {
        return UnitOfTime.toUnit(aTime).format(aTime, 2);
    }

    public static UnitOfTime toUnit(double aTimeValue) {
        int i;
        double absTime = Math.abs(aTimeValue);
        UnitOfTime[] values = UnitOfTime.values();
        for (i = 0; i < values.length && !(absTime >= values[i].getFactor()); ++i) {
        }
        return values[Math.min(i, values.length - 1)];
    }

    public String format(double aTime, int aScale) {
        if (Math.abs(aTime) < 1.0E-16 && this != S) {
            return S.format(0.0, aScale);
        }
        Double time = aTime / this.getFactor();
        String format = String.format("%%.%df%%s", aScale);
        return String.format(format, time, this.getDisplayName());
    }

    public String formatHumanReadable(double aTime) {
        if (Math.abs(aTime) < 1.0E-16 && this != S) {
            return S.formatHumanReadable(0.0);
        }
        Double time = aTime / this.getFactor();
        String formattedTime = String.format("%.9f", time);
        formattedTime = formattedTime.replaceAll("(\\d)0+$", "$1");
        return String.format("%s%s", formattedTime, this.getDisplayName());
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public double getFactor() {
        return this.factor;
    }

    public UnitOfTime predecessor() {
        int i = this.ordinal();
        return i < 1 ? null : UnitOfTime.values()[i - 1];
    }

    public UnitOfTime successor() {
        UnitOfTime[] values = UnitOfTime.values();
        int i = this.ordinal();
        if (i >= values.length - 1) {
            return null;
        }
        return values[i + 1];
    }
}

