/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.api.data;

public abstract class BaseData<TYPE extends Comparable<? super TYPE>>
implements Comparable<TYPE> {
    private final int idx;
    private final int channelIdx;
    private final int startSampleIdx;
    private final int endSampleIdx;
    private final String eventName;

    protected BaseData(int aIdx, int aChannelIdx, int aStartSampleIdx, int aEndSampleIdx) {
        this(aIdx, aChannelIdx, aStartSampleIdx, aEndSampleIdx, null);
    }

    protected BaseData(int aIdx, int aChannelIdx, int aStartSampleIdx, int aEndSampleIdx, String aEventName) {
        this.idx = aIdx;
        this.channelIdx = aChannelIdx;
        this.startSampleIdx = aStartSampleIdx;
        this.endSampleIdx = aEndSampleIdx;
        this.eventName = aEventName;
    }

    protected BaseData(int aIdx, int aChannelIdx, int aSampleIdx, String aEventName) {
        this(aIdx, aChannelIdx, aSampleIdx, aSampleIdx, aEventName);
    }

    @Override
    public int compareTo(TYPE aComparable) {
        return this.idx - ((BaseData)aComparable).getIndex();
    }

    public boolean equals(Object aObject) {
        if (this == aObject) {
            return true;
        }
        if (aObject == null || !(aObject instanceof BaseData)) {
            return false;
        }
        BaseData other = (BaseData)aObject;
        if (this.idx != other.idx) {
            return false;
        }
        if (this.channelIdx != other.channelIdx) {
            return false;
        }
        if (this.startSampleIdx != other.startSampleIdx) {
            return false;
        }
        return this.endSampleIdx == other.endSampleIdx;
    }

    public final int getChannelIdx() {
        return this.channelIdx;
    }

    public final int getEndSampleIndex() {
        return this.endSampleIdx;
    }

    public final String getEventName() {
        return this.eventName;
    }

    public final int getIndex() {
        return this.idx;
    }

    public final int getStartSampleIndex() {
        return this.startSampleIdx;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.idx;
        result = 31 * result + this.startSampleIdx;
        result = 31 * result + this.endSampleIdx;
        return result;
    }

    public boolean isEvent() {
        return this.eventName != null && !this.eventName.trim().isEmpty();
    }
}

