/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.tool.linedecoder.impl.decoders;

import nl.lxtreme.ols.api.acquisition.AcquisitionResult;
import nl.lxtreme.ols.api.data.annotation.Annotation;
import nl.lxtreme.ols.api.data.annotation.AnnotationListener;
import nl.lxtreme.ols.api.tools.ToolProgressListener;
import nl.lxtreme.ols.tool.base.annotation.SampleDataAnnotation;
import nl.lxtreme.ols.tool.linedecoder.LineDecoder;
import nl.lxtreme.ols.tool.linedecoder.LineDecoderToolContext;

public class NonReturnToZeroDecoder
implements LineDecoder {
    @Override
    public boolean canHandleInversion() {
        return true;
    }

    @Override
    public boolean canRecoverClock() {
        return false;
    }

    @Override
    public AcquisitionResult decode(LineDecoderToolContext aContext, AnnotationListener aAnnotationListener, ToolProgressListener aListener) throws Exception {
        AcquisitionResult inputData = aContext.getData();
        int[] values = inputData.getValues();
        long[] timestamps = inputData.getTimestamps();
        int dataIdx = aContext.getLineChannels()[0];
        int clockIdx = aContext.getLineChannels()[1];
        int dataMask = 1 << dataIdx;
        int clockMask = 1 << clockIdx;
        aAnnotationListener.clearAnnotations(dataIdx);
        int startIdx = aContext.getStartSampleIndex();
        int endIdx = aContext.getEndSampleIndex();
        int symbolStartIdx = -1;
        int symbolSize = 8;
        int bitCount = 0;
        int symbol = 0;
        for (int i = startIdx; i < endIdx; ++i) {
            int clockValue = values[i] & clockMask;
            if (clockValue == 0) continue;
            if (symbolStartIdx < 0) {
                symbolStartIdx = i;
            }
            int dataValue = values[i] & dataMask;
            symbol <<= 1;
            if (dataValue != 0) {
                symbol |= 1;
            }
            if (++bitCount != symbolSize) continue;
            aAnnotationListener.onAnnotation((Annotation)this.createAnnotation(dataIdx, timestamps[symbolStartIdx], timestamps[i], symbol));
            symbol = 0;
            bitCount = 0;
            symbolStartIdx = -1;
        }
        return null;
    }

    @Override
    public String[] getLineNames() {
        return new String[]{"Data", "Clock"};
    }

    @Override
    public String getName() {
        return "Non-return to zero";
    }

    private SampleDataAnnotation createAnnotation(int aIndex, long aStartTime, long aEndTime, int aSymbol) {
        return new SampleDataAnnotation(aIndex, aStartTime, aEndTime, String.format("%1$c (%1$x)", aSymbol));
    }
}

