/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.util.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import nl.lxtreme.ols.util.HostUtils;
import nl.lxtreme.ols.util.swing.SwingComponentUtils;

public final class StandardActionFactory {
    public static final String CLOSE_ACTION_ID = "CloseAction";

    private StandardActionFactory() {
    }

    public static final Action createCancelAction() {
        return new CancelAction();
    }

    public static final JButton createCancelButton() {
        Action action = StandardActionFactory.createCancelAction();
        return StandardActionFactory.createButton(action);
    }

    public static final Action createCloseAction() {
        return new CloseAction();
    }

    public static final JButton createCloseButton() {
        Action action = StandardActionFactory.createCloseAction();
        return StandardActionFactory.createButton(action);
    }

    public static final Action createOkAction() {
        return new OkAction();
    }

    public static final JButton createOkButton() {
        Action action = StandardActionFactory.createOkAction();
        return StandardActionFactory.createButton(action);
    }

    private static JButton createButton(Action aAction) {
        String actionName = (String)aAction.getValue("Name");
        if (actionName == null) {
            actionName = aAction.toString();
        }
        JButton button = new JButton(aAction);
        SwingComponentUtils.registerKeystroke(button, aAction, actionName);
        return button;
    }

    private static <T extends CloseAction.Closeable> T findCloseableParent(Component aComponent, Class<T> aImplementingType) {
        Object closeableParent;
        if (aComponent instanceof JMenuItem) {
            Container parent = ((JMenuItem)aComponent).getParent();
            closeableParent = StandardActionFactory.findCloseableParent(parent, aImplementingType);
        } else if (aComponent instanceof JPopupMenu) {
            Component invoker = ((JPopupMenu)aComponent).getInvoker();
            closeableParent = StandardActionFactory.findCloseableParent(invoker, aImplementingType);
        } else {
            closeableParent = (CloseAction.Closeable)SwingComponentUtils.getAncestorOfClass(aImplementingType, aComponent);
        }
        return closeableParent;
    }

    static abstract class AbstractStatusAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private final DialogStatus status;

        public AbstractStatusAction(DialogStatus aStatus) {
            super(aStatus.name().substring(0, 1).concat(aStatus.name().substring(1).toLowerCase()));
            this.status = aStatus;
        }

        @Override
        public void actionPerformed(ActionEvent aEvent) {
            if (aEvent.getSource() instanceof Component) {
                Component source = (Component)aEvent.getSource();
                StatusAwareCloseableDialog closeableParent = (StatusAwareCloseableDialog)StandardActionFactory.findCloseableParent(source, StatusAwareCloseableDialog.class);
                if (closeableParent == null) {
                    throw new RuntimeException("Failed to find closeable parent?!");
                }
                if (closeableParent.setDialogStatus(this.status)) {
                    closeableParent.close();
                    if (closeableParent instanceof Window) {
                        ((Window)((Object)closeableParent)).dispose();
                    }
                }
            }
        }
    }

    public static interface StatusAwareCloseableDialog
    extends CloseAction.Closeable {
        public boolean setDialogStatus(DialogStatus var1);
    }

    public static final class OkAction
    extends AbstractStatusAction {
        private static final long serialVersionUID = 1L;

        public OkAction() {
            super(DialogStatus.OK);
        }
    }

    public static enum DialogStatus {
        OK,
        CANCEL;


        public boolean isCancel() {
            return this == CANCEL;
        }

        public boolean isOk() {
            return this == OK;
        }
    }

    public static final class CloseAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CloseAction() {
            super("Close");
            this.putValue("ShortDescription", "Closes this dialog");
            if (HostUtils.getHostInfo().isMacOS()) {
                this.putValue("AcceleratorKey", SwingComponentUtils.createMenuKeyMask(87, new int[0]));
            } else {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(27, 0));
            }
        }

        @Override
        public void actionPerformed(ActionEvent aEvent) {
            if (aEvent.getSource() instanceof Component) {
                Component source = (Component)aEvent.getSource();
                Closeable closeableParent = StandardActionFactory.findCloseableParent(source, Closeable.class);
                if (closeableParent == null) {
                    throw new RuntimeException("Failed to find closeable parent?!");
                }
                closeableParent.close();
                if (closeableParent instanceof Window) {
                    ((Window)((Object)closeableParent)).dispose();
                }
            }
        }

        public static interface Closeable {
            public void close();
        }
    }

    public static final class CancelAction
    extends AbstractStatusAction {
        private static final long serialVersionUID = 1L;

        public CancelAction() {
            super(DialogStatus.CANCEL);
        }
    }
}

