/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.util;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.noos.xing.mydoggy.plaf.cleaner.Cleaner;
import org.noos.xing.mydoggy.plaf.ui.drag.DragListener;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class RemoveNotifyDragListener
implements PropertyChangeListener,
Cleaner {
    protected Component[] components;
    protected DragListener dragListener;

    public RemoveNotifyDragListener(Component components, DragListener dragListener) {
        this.components = new Component[]{components};
        this.dragListener = dragListener;
        this.installListeners();
    }

    public RemoveNotifyDragListener(DragListener dragListener, Component ... components) {
        this.components = components;
        this.dragListener = dragListener;
        this.installListeners();
    }

    public void cleanup() {
        this.uninstallListeners();
        this.components = null;
        this.dragListener = null;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getNewValue() == null) {
            this.uninstallListeners();
        } else {
            this.installListeners();
        }
    }

    protected void installListeners() {
        if (this.components == null) {
            return;
        }
        for (Component component : this.components) {
            SwingUtil.registerDragListener(component, this.dragListener);
        }
    }

    protected void uninstallListeners() {
        if (this.components == null) {
            return;
        }
        for (Component component : this.components) {
            SwingUtil.unregisterDragListener(component);
        }
    }
}

