/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.cmp;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.SwingConstants;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class AggregateIcon
implements Icon,
SwingConstants {
    private int orientation;
    private Icon leftIcon;
    private Icon rightIcon;
    private boolean leftVisible;
    private boolean rightVisible;
    private Rectangle lastPaintedLeftRec;
    private Rectangle lastPaintedRightRec;

    public AggregateIcon(Icon leftIcon, Icon rightIcon, int orientation) {
        this.leftIcon = leftIcon;
        this.rightIcon = rightIcon;
        this.orientation = orientation;
        this.rightVisible = true;
        this.leftVisible = true;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        boolean leftVisible = this.isLeftVisible();
        boolean rightVisible = this.isRightVisible();
        Icon leftIcon = this.getLeftIcon();
        Icon righIcon = this.getRightIcon();
        switch (this.orientation) {
            case 0: {
                if (leftVisible && rightVisible) {
                    if (leftIcon.getIconHeight() > righIcon.getIconHeight()) {
                        leftIcon.paintIcon(c, g, x, y);
                        this.lastPaintedLeftRec = new Rectangle(x, y, leftIcon.getIconWidth(), leftIcon.getIconHeight());
                        int rightX = x + leftIcon.getIconWidth();
                        int rightY = y + (leftIcon.getIconHeight() - righIcon.getIconHeight()) / 2;
                        righIcon.paintIcon(c, g, rightX, rightY);
                        this.lastPaintedRightRec = new Rectangle(rightX, rightY, righIcon.getIconWidth(), righIcon.getIconHeight());
                        break;
                    }
                    if (leftIcon.getIconHeight() == righIcon.getIconHeight()) {
                        leftIcon.paintIcon(c, g, x, y);
                        this.lastPaintedLeftRec = new Rectangle(x, y, leftIcon.getIconWidth(), leftIcon.getIconHeight());
                        int rightX = x + leftIcon.getIconWidth();
                        int rightY = y;
                        righIcon.paintIcon(c, g, rightX, rightY);
                        this.lastPaintedRightRec = new Rectangle(rightX, rightY, righIcon.getIconWidth(), righIcon.getIconHeight());
                        break;
                    }
                    int leftY = y + (righIcon.getIconHeight() - leftIcon.getIconHeight()) / 2;
                    leftIcon.paintIcon(c, g, x, leftY);
                    this.lastPaintedLeftRec = new Rectangle(x, leftY, leftIcon.getIconWidth(), leftIcon.getIconHeight());
                    int rightX = x + leftIcon.getIconWidth();
                    int rightY = y;
                    righIcon.paintIcon(c, g, rightX, rightY);
                    this.lastPaintedRightRec = new Rectangle(rightX, rightY, righIcon.getIconWidth(), righIcon.getIconHeight());
                    break;
                }
                if (leftVisible) {
                    leftIcon.paintIcon(c, g, x, y);
                    this.lastPaintedLeftRec = new Rectangle(x, y, leftIcon.getIconWidth(), leftIcon.getIconHeight());
                    this.lastPaintedRightRec = null;
                    break;
                }
                if (!rightVisible) break;
                righIcon.paintIcon(c, g, x, y);
                this.lastPaintedRightRec = new Rectangle(x, y, righIcon.getIconWidth(), righIcon.getIconHeight());
                this.lastPaintedLeftRec = null;
                break;
            }
            case 1: {
                if (leftVisible && rightVisible) {
                    if (leftIcon.getIconWidth() > righIcon.getIconWidth()) {
                        leftIcon.paintIcon(c, g, x, y);
                        this.lastPaintedLeftRec = new Rectangle(x, y, leftIcon.getIconWidth(), leftIcon.getIconHeight());
                        int rightX = x + (leftIcon.getIconWidth() - righIcon.getIconWidth()) / 2;
                        int rightY = y + leftIcon.getIconHeight();
                        righIcon.paintIcon(c, g, rightX, rightY);
                        this.lastPaintedRightRec = new Rectangle(rightX, rightY, righIcon.getIconWidth(), righIcon.getIconHeight());
                        break;
                    }
                    if (leftIcon.getIconWidth() == righIcon.getIconWidth()) {
                        leftIcon.paintIcon(c, g, x, y);
                        this.lastPaintedLeftRec = new Rectangle(x, y, leftIcon.getIconWidth(), leftIcon.getIconHeight());
                        int rightX = x;
                        int rightY = y + leftIcon.getIconHeight();
                        righIcon.paintIcon(c, g, rightX, rightY);
                        this.lastPaintedRightRec = new Rectangle(rightX, rightY, righIcon.getIconWidth(), righIcon.getIconHeight());
                        break;
                    }
                    int leftX = x + (righIcon.getIconWidth() - leftIcon.getIconWidth()) / 2;
                    leftIcon.paintIcon(c, g, leftX, y);
                    this.lastPaintedLeftRec = new Rectangle(leftX, y, leftIcon.getIconWidth(), leftIcon.getIconHeight());
                    int rightX = x;
                    int rightY = y + leftIcon.getIconHeight();
                    righIcon.paintIcon(c, g, rightX, rightY);
                    this.lastPaintedRightRec = new Rectangle(rightX, rightY, righIcon.getIconWidth(), righIcon.getIconHeight());
                    break;
                }
                if (leftVisible) {
                    leftIcon.paintIcon(c, g, x, y);
                    this.lastPaintedLeftRec = new Rectangle(x, y, leftIcon.getIconWidth(), leftIcon.getIconHeight());
                    this.lastPaintedRightRec = null;
                    break;
                }
                if (!rightVisible) break;
                righIcon.paintIcon(c, g, x, y);
                this.lastPaintedRightRec = new Rectangle(x, y, righIcon.getIconWidth(), righIcon.getIconHeight());
                this.lastPaintedLeftRec = null;
            }
        }
    }

    public int getIconWidth() {
        if (this.orientation == 0) {
            return (this.isLeftVisible() ? SwingUtil.getIconWidth(this.getLeftIcon()) : 0) + (this.isRightVisible() ? SwingUtil.getIconWidth(this.getRightIcon()) : 0);
        }
        return Math.max(this.isLeftVisible() ? SwingUtil.getIconWidth(this.getLeftIcon()) : 0, this.isRightVisible() ? SwingUtil.getIconWidth(this.getRightIcon()) : 0);
    }

    public int getIconHeight() {
        if (this.orientation == 1) {
            return SwingUtil.getIconHeight(this.getLeftIcon()) + SwingUtil.getIconHeight(this.getRightIcon());
        }
        return Math.max(SwingUtil.getIconHeight(this.getLeftIcon()), SwingUtil.getIconHeight(this.getRightIcon()));
    }

    public Rectangle getLastPaintedLeftRec() {
        return this.lastPaintedLeftRec;
    }

    public Rectangle getLastPaintedRightRec() {
        return this.lastPaintedRightRec;
    }

    public Icon getLeftIcon() {
        return this.leftIcon;
    }

    public void setLeftIcon(Icon leftIcon) {
        this.leftIcon = leftIcon;
    }

    public Icon getRightIcon() {
        return this.rightIcon;
    }

    public void setRightIcon(Icon rightIcon) {
        this.rightIcon = rightIcon;
    }

    public boolean isLeftVisible() {
        return this.leftVisible && this.getLeftIcon() != null;
    }

    public void setLeftVisible(boolean leftVisible) {
        this.leftVisible = leftVisible;
    }

    public boolean isRightVisible() {
        return this.rightVisible && this.getRightIcon() != null;
    }

    public void setRightVisible(boolean rightVisible) {
        this.rightVisible = rightVisible;
    }
}

