/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.persistence.xml;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLWriter {
    protected static final Object SEEN_NOTHING = new Object();
    protected static final Object SEEN_ELEMENT = new Object();
    protected static final Object SEEN_DATA = new Object();
    protected int elementLevel = 0;
    protected Writer output;
    protected final Attributes EMPTY_ATTS = new AttributesImpl();
    protected Object state = SEEN_NOTHING;
    protected Stack<Object> stateStack;
    protected int indentStep = 0;
    protected int depth = 0;

    public XMLWriter(Writer writer) {
        this.init(writer);
    }

    public void reset() {
        this.depth = 0;
        this.state = SEEN_NOTHING;
        this.stateStack = new Stack();
        this.elementLevel = 0;
    }

    public void flush() throws IOException {
        this.output.flush();
    }

    public void setOutput(Writer writer) {
        this.output = writer == null ? new OutputStreamWriter(System.out) : writer;
    }

    public Writer getOutput() {
        return this.output;
    }

    public void startDocument() throws SAXException {
        this.reset();
        this.write("<?xml version=\"1.0\" standalone=\"yes\"?>\n\n");
    }

    public void endDocument() throws SAXException {
        this.write('\n');
        try {
            this.flush();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void startElement(String elementName, Attributes atts) throws SAXException {
        this.stateStack.push(SEEN_ELEMENT);
        this.state = SEEN_NOTHING;
        if (this.depth > 0) {
            this.characters("\n");
        }
        this.doIndent();
        ++this.elementLevel;
        this.write('<');
        this.writeName(elementName);
        this.writeAttributes(atts);
        this.write('>');
        ++this.depth;
    }

    public void endElement(String elementName) throws SAXException {
        --this.depth;
        if (this.state == SEEN_ELEMENT) {
            this.characters("\n");
            this.doIndent();
        }
        this.write("</");
        this.writeName(elementName);
        this.write('>');
        if (this.elementLevel == 1) {
            this.write('\n');
        }
        --this.elementLevel;
        this.state = this.stateStack.pop();
    }

    public void characters(char[] ch, int start, int len) throws SAXException {
        this.state = SEEN_DATA;
        this.writeEsc(ch, start, len, false);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.writeEsc(ch, start, length, false);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.write("<?");
        this.write(target);
        this.write(' ');
        this.write(data);
        this.write("?>");
        if (this.elementLevel < 1) {
            this.write('\n');
        }
    }

    public void dataElement(String elementName, Attributes atts) throws SAXException {
        this.state = SEEN_ELEMENT;
        if (this.depth > 0) {
            this.characters("\n");
        }
        this.doIndent();
        this.state = SEEN_ELEMENT;
        this.write('<');
        this.writeName(elementName);
        this.writeAttributes(atts);
        this.write("/>");
    }

    public void startElement(String localName) throws SAXException {
        this.startElement(localName, this.EMPTY_ATTS);
    }

    public void dataElement(String elementName, Attributes atts, String content) throws SAXException {
        this.startElement(elementName, atts);
        this.characters(content);
        this.endElement(elementName);
    }

    public void characters(String data) throws SAXException {
        if (data == null) {
            return;
        }
        char[] ch = data.toCharArray();
        this.characters(ch, 0, ch.length);
    }

    public int getIndentStep() {
        return this.indentStep;
    }

    public void setIndentStep(int indentStep) {
        this.indentStep = indentStep;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void cdata(String s) throws SAXException {
        this.state = SEEN_ELEMENT;
        if (this.depth > 0) {
            this.characters("\n");
        }
        this.doIndent();
        this.state = SEEN_ELEMENT;
        this.write("<![CDATA[");
        this.writeCDATAEsc(s.toCharArray(), 0, s.length());
        this.write("]]>");
    }

    protected void init(Writer writer) {
        this.setOutput(writer);
        this.reset();
        this.setIndentStep(4);
    }

    protected void write(char c) throws SAXException {
        try {
            this.output.write(c);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    protected void write(String s) throws SAXException {
        try {
            this.output.write(s);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    protected void writeAttributes(Attributes atts) throws SAXException {
        int len = atts.getLength();
        for (int i = 0; i < len; ++i) {
            this.write(' ');
            this.writeName(atts.getLocalName(i));
            this.write("=\"");
            char[] ch = atts.getValue(i).toCharArray();
            this.writeEsc(ch, 0, ch.length, true);
            this.write('\"');
        }
    }

    protected void writeEsc(char[] ch, int start, int length, boolean isAttVal) throws SAXException {
        block6: for (int i = start; i < start + length; ++i) {
            switch (ch[i]) {
                case '<': {
                    this.write("&lt;");
                    continue block6;
                }
                case '>': {
                    this.write("&gt;");
                    continue block6;
                }
                case '\"': {
                    if (isAttVal) {
                        this.write("&quot;");
                        continue block6;
                    }
                    this.write('\"');
                    continue block6;
                }
                case '&': {
                    this.write("&amp;");
                    continue block6;
                }
                default: {
                    if (ch[i] > '\u007f') {
                        this.write("&#");
                        this.write(Integer.toString(ch[i]));
                        this.write(';');
                        continue block6;
                    }
                    this.write(ch[i]);
                }
            }
        }
    }

    protected void writeCDATAEsc(char[] ch, int start, int length) throws SAXException {
        for (int i = start; i < start + length; ++i) {
            if (ch[i] > '\u007f') {
                this.write("&#");
                this.write(Integer.toString(ch[i]));
                this.write(';');
                continue;
            }
            this.write(ch[i]);
        }
    }

    protected void writeName(String elementName) throws SAXException {
        this.write(elementName);
    }

    protected void doIndent() throws SAXException {
        if (this.indentStep > 0 && this.depth > 0) {
            int n = this.indentStep * this.depth;
            char[] ch = new char[n];
            for (int i = 0; i < n; ++i) {
                ch[i] = 32;
            }
            this.characters(ch, 0, n);
        }
    }

    public void close() throws IOException {
        this.flush();
        this.output.close();
    }
}

