/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.descriptors;

import java.beans.PropertyChangeEvent;
import org.noos.xing.mydoggy.SlidingTypeDescriptor;
import org.noos.xing.mydoggy.ToolWindowType;
import org.noos.xing.mydoggy.ToolWindowTypeDescriptor;
import org.noos.xing.mydoggy.plaf.descriptors.DefaultToolWindowTypeDescriptor;
import org.noos.xing.mydoggy.plaf.descriptors.InternalTypeDescriptor;
import org.noos.xing.mydoggy.plaf.ui.ToolWindowDescriptor;

public class DefaultSlidingTypeDescriptor
extends DefaultToolWindowTypeDescriptor
implements SlidingTypeDescriptor,
InternalTypeDescriptor {
    private boolean transparentMode;
    private float transparentRatio;
    private int transparentDelay;

    public DefaultSlidingTypeDescriptor() {
        this.transparentMode = true;
        this.transparentRatio = 0.5f;
        this.transparentDelay = 1000;
        this.autoHide = true;
    }

    public DefaultSlidingTypeDescriptor(ToolWindowDescriptor toolWindowDescriptor, DefaultSlidingTypeDescriptor parent, int transparentDelay, float transparentRatio, boolean transparentMode, boolean enabled, boolean animating, boolean autoHide, boolean idVisibleOnTitleBar, boolean hideRepresentativeButtonOnVisible, boolean titleBarButtonsVisible, boolean titleBarVisible) {
        super(toolWindowDescriptor, parent, enabled, animating, autoHide, idVisibleOnTitleBar, hideRepresentativeButtonOnVisible, titleBarButtonsVisible, titleBarVisible);
        this.transparentDelay = transparentDelay;
        this.transparentRatio = transparentRatio;
        this.transparentMode = transparentMode;
    }

    public ToolWindowType getType() {
        return ToolWindowType.SLIDING;
    }

    public float getTransparentRatio() {
        return this.transparentRatio;
    }

    public void setTransparentRatio(float transparentRatio) {
        if (this.transparentRatio == transparentRatio) {
            return;
        }
        if (transparentRatio < 0.0f || transparentRatio > 1.0f) {
            throw new IllegalArgumentException("Invalid transparent ratio. Valid range is [0.0f, 1.0f]. [transparentRatio : " + transparentRatio + "]");
        }
        float old = this.transparentRatio;
        this.transparentRatio = transparentRatio;
        this.firePropertyChangeEvent("transparentRatio", Float.valueOf(old), Float.valueOf(transparentRatio));
    }

    public boolean isTransparentMode() {
        return this.transparentMode;
    }

    public void setTransparentMode(boolean transparentMode) {
        if (this.transparentMode == transparentMode) {
            return;
        }
        boolean old = this.transparentMode;
        this.transparentMode = transparentMode;
        this.firePropertyChangeEvent("transparentMode", old, transparentMode);
    }

    public int getTransparentDelay() {
        return this.transparentDelay;
    }

    public void setTransparentDelay(int transparentDelay) {
        if (this.transparentDelay == transparentDelay) {
            return;
        }
        int old = this.transparentDelay;
        this.transparentDelay = transparentDelay;
        this.firePropertyChangeEvent("transparentDelay", old, transparentDelay);
    }

    public ToolWindowTypeDescriptor cloneMe(ToolWindowDescriptor toolWindowDescriptor) {
        return new DefaultSlidingTypeDescriptor(toolWindowDescriptor, this, this.transparentDelay, this.transparentRatio, this.transparentMode, this.enabled, this.animating, this.autoHide, this.idVisibleOnTitleBar, this.hideRepresentativeButtonOnVisible, this.titleBarButtonsVisible, this.titleBarVisible);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if ("transparentMode".equals(evt.getPropertyName())) {
            this.setTransparentMode((Boolean)evt.getNewValue());
        } else if ("transparentRatio".equals(evt.getPropertyName())) {
            this.setTransparentRatio(((Float)evt.getNewValue()).floatValue());
        } else if ("transparentDelay".equals(evt.getPropertyName())) {
            this.setTransparentDelay((Integer)evt.getNewValue());
        }
    }
}

