/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.ols.device.generic;

import java.io.Closeable;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.lxtreme.ols.api.acquisition.AcquisitionProgressListener;
import nl.lxtreme.ols.api.acquisition.AcquisitionResult;
import nl.lxtreme.ols.api.data.CapturedData;
import nl.lxtreme.ols.api.devices.AcquisitionTask;
import nl.lxtreme.ols.device.generic.GenericDeviceConfigDialog;
import nl.lxtreme.ols.util.HostUtils;

public final class GenericDeviceAcquisitionTask
implements AcquisitionTask {
    private static final Logger LOG = Logger.getLogger(GenericDeviceAcquisitionTask.class.getName());
    private final AcquisitionProgressListener progressListener;
    private final GenericDeviceConfigDialog deviceConfig;
    private InputStream inputStream;

    public GenericDeviceAcquisitionTask(GenericDeviceConfigDialog aDeviceConfig, AcquisitionProgressListener aProgressListener) {
        this.deviceConfig = aDeviceConfig;
        this.progressListener = aProgressListener;
    }

    public AcquisitionResult call() throws IOException {
        int width = this.deviceConfig.getSampleWidth();
        int depth = this.deviceConfig.getSampleDepth();
        int rate = this.deviceConfig.getSampleRate();
        int channels = this.deviceConfig.getChannelCount();
        int count = depth * width;
        int[] values = new int[count];
        long[] timestamps = new long[count];
        this.inputStream = new FileInputStream(this.deviceConfig.getDevicePath());
        try {
            int idx = 0;
            while (!Thread.currentThread().isInterrupted() && idx < count) {
                int sample = this.readSample(width);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Read: 0x{0}", Integer.toHexString(sample));
                }
                values[idx] = sample;
                timestamps[idx] = idx;
                this.progressListener.acquisitionInProgress((int)((double)idx++ * 100.0 / (double)count));
            }
            long absLength = timestamps[idx - 1];
            int enabledChannels = (1 << channels) - 1;
            CapturedData capturedData = new CapturedData(values, timestamps, -1L, rate, channels, enabledChannels, absLength);
            return capturedData;
        }
        catch (IOException exception) {
            throw exception;
        }
        finally {
            HostUtils.closeResource((Closeable)this.inputStream);
        }
    }

    private int readSample(int aSampleWidth) throws IOException {
        int value = 0;
        for (int i = 0; !Thread.currentThread().isInterrupted() && i < aSampleWidth; ++i) {
            int v = this.inputStream.read();
            if (v < 0) {
                throw new EOFException("Data readout interrupted: EOF.");
            }
            value |= v << 8 * i;
        }
        return value;
    }
}

