// LISTING 26.2. Zmiana wartości atrybutu przechowującego referencję do obiektu Insighta

import com.atlassian.jira.component.ComponentAccessor;
import com.onresolve.scriptrunner.runner.customisers.WithPlugin;
@WithPlugin("com.riadalabs.jira.plugins.insight")

// 1. Pobranie komponentu IQLFacade.
Class iqlFacadeClass = ComponentAccessor.getPluginAccessor().getClassLoader().loadClass("com.riadalabs.jira.plugins.insight.channel.external.api.facade.IQLFacade");
def iqlFacade = ComponentAccessor.getOSGiComponentInstanceOfType(iqlFacadeClass) as com.riadalabs.jira.plugins.insight.channel.external.api.facade.IQLFacade;

// 2. Pobranie komponentu ObjectFacade.
Class objectFacadeClass = ComponentAccessor.getPluginAccessor().getClassLoader().loadClass("com.riadalabs.jira.plugins.insight.channel.external.api.facade.ObjectFacade");
def objectFacade = ComponentAccessor.getOSGiComponentInstanceOfType(objectFacadeClass) as com.riadalabs.jira.plugins.insight.channel.external.api.facade.ObjectFacade;

// 3. Pobranie komponentu ObjectTypeAttributeFacade.
Class objectTypeAttributeFacadeClass = ComponentAccessor.getPluginAccessor().getClassLoader().loadClass("com.riadalabs.jira.plugins.insight.channel.external.api.facade.ObjectTypeAttributeFacade");
def objectTypeAttributeFacade = ComponentAccessor.getOSGiComponentInstanceOfType(objectTypeAttributeFacadeClass) as com.riadalabs.jira.plugins.insight.channel.external.api.facade.ObjectTypeAttributeFacade;

// 4. Pobranie komponentu ObjectAttributeBeanFactory.
Class objectAttributeBeanFactoryClass = ComponentAccessor.getPluginAccessor().getClassLoader().loadClass("com.riadalabs.jira.plugins.insight.services.model.factory.ObjectAttributeBeanFactory");
def objectAttributeBeanFactory = ComponentAccessor.getOSGiComponentInstanceOfType(objectAttributeBeanFactoryClass) as com.riadalabs.jira.plugins.insight.services.model.factory.ObjectAttributeBeanFactory;

// 5. Wyszukanie i pobranie obiektu Insighta określonego pracownika.
def employeesObjectToChange = iqlFacade.findObjectsByIQLAndSchema(1, "objectType = Employees and \"Name\" = \"Vincent Wong\"").get(0).createMutable();

// 6. Wyszukanie i pobranie obiektu Insighta określonego działu, którego obiekt będzie przechowywany w atrybucie obiektu pracownika.
def branchesObjectToAdd = iqlFacade.findObjectsByIQLAndSchema(1, "objectType = Branches and \"Name\" = \"Sales\"").get(0);

// 7. Wstawienie obiektu Branches jako atrybutu w obiekcie Employees.

// 7.1. Pobranie ObjectTypeAttributeBean dla atrybutu Related branch o identyfikatorze 20 i zrzutowanie do typu edytowalnego.
def relatedBranchObjectTypeAttributeBean = objectTypeAttributeFacade.loadObjectTypeAttributeBean(20).createMutable();

// 7.2. Utworzenie obiektu ObjectAttributeBean z nową referencją do obiektu typu Branches.
def newRelatedBranchObjectAttributeBean = objectAttributeBeanFactory.createObjectAttributeBeanForObject(employeesObjectToChange, relatedBranchObjectTypeAttributeBean, branchesObjectToAdd.getName());

// 7.3. Wykonanie zmiany.
objectFacade.storeObjectAttributeBean(newRelatedBranchObjectAttributeBean);