// LISTING 17.2. Ustawienie wartości select lists, radio buttons i checkboxes

import com.atlassian.jira.component.ComponentAccessor;

// 1. Pobranie obiektów typu FieldForm pól formularza.
def branchesFieldForm = getFieldById("customfield_10601");

// 2. Ograniczenie dostępnych opcji w select list, radio button lub checkbox.

// 2.1. Pobranie obiektu typu interfejsowego CustomField.
def branchesField = ComponentAccessor.getCustomFieldManager().getCustomFieldObject(10601L);

// 2.2. Pobranie konfiguracji custom fieldu.
def branchesFieldConfig = branchesField.getRelevantConfig(getIssueContext());

// 2.3. Pobranie dostępnych opcji w custom fieldzie.
def branchesFieldOptions = ComponentAccessor.getOptionsManager().getOptions(branchesFieldConfig);

// 2.4. Ograniczenie wyświetlanych opcji w screenie.
def allowedOptions = branchesFieldOptions.findAll() {
    option -> 
        option.getOptionId()>=10300L &&
        option.getOptionId()<= 10302L;
};

// 2.5. Ustawienie dozwolonych opcji w select list, checkboksie lub radio buttonie.
branchesFieldForm.setFieldOptions(allowedOptions);

// 3. (Opcja 1) Wybranie jednej opcji z select list (single choice) lub radio buttona.
branchesFieldForm.setFormValue("IT");

// 4. (Opcja 2) Wybranie wielu opcji z select list (multiple choices) lub checkboksa.
branchesFieldForm.setFormValue(["IT", "HR"]);