// LISTING 15.8. Przypisanie zgłoszenia do wersji

import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.component.ComponentAccessor;

// 1. Pobranie obiektu typu interfejsowego ApplicationUser do wykonania zmiany w zgłoszeniu.
def adminUser = ComponentAccessor.getUserManager().getUserByName("admin");

// 2. Pobranie menedżerów.
def versionManager = ComponentAccessor.getVersionManager();
def issueManager = ComponentAccessor.getIssueManager();

// 3. Pobranie obiektu typu interfejsowego Issue.
def issue = issueManager.getIssueObject("SKX-4") as MutableIssue;

// 4. Pobranie wersji Version 3 o identyfikatorze 10203.
def versionToAdd = versionManager.getVersion(10203L);

// 5. (Opcja 1) Dodanie wersji do listy istniejących w zgłoszeniu.
def currentIssueVersion = issue.getFixVersions();
currentIssueVersion.add(versionToAdd);
issue.setFixVersions(currentIssueVersion);
issueManager.updateIssue(adminUser, issue, EventDispatchOption.ISSUE_UPDATED, false);

// 6. (Opcja 2) Nadpisanie istniejących wersji w zgłoszeniu.
Collection<Version> versionListToAdd = new ArrayList<>();
issue.setFixVersions(currentIssueVersion);
versionListToAdd.add(versionToAdd);
issueManager.updateIssue(adminUser, issue, EventDispatchOption.ISSUE_UPDATED, false);