// LISTING 15.12. Tworzenie projektu z domyślną konfiguracją

import com.atlassian.jira.project.AssigneeTypes;
import com.atlassian.jira.bc.project.ProjectCreationData.Builder;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.bc.project.ProjectService;

// 1. Pobranie obiektu typu interfejsowego ApplicationUser użytkownika z uprawnieniami do tworzenia projektów.
def adminUser = ComponentAccessor.getUserManager().getUserByName("admin");

// 2. Pobranie obiektu typu interfejsowego ApplicationUser użytkownika będącego liderem projektu (project lead).
def projectLead = ComponentAccessor.getUserManager().getUserByName("jnowak");

// 3. Pobranie komponentów i menedżerów.
def projectService = ComponentAccessor.getComponent(ProjectService);

// 4. Utworzenie obiektu buildera do przygotowania danych projektu.
Builder builder = new Builder();

// 5. Zdefiniowanie danych projektu w obiekcie typu Builder.
// Metoda withType przyjmuje wartości typu projektu, np. software, business.
// Metoda withAssigneeType przyjmuje wartości enum z AssigneeType, które są widoczne w podpowiedziach konsoli.
builder
    .withKey("RA1")
    .withName("Rozwój aplikacji")
    .withLead(projectLead)
    .withDescription("Projekt rozwoju aplikacji")
    .withType("software")
    .withUrl("https://helion.pl")
    .withAssigneeType(AssigneeTypes.PROJECT_LEAD);

def projectData = builder.build();

// 6. Wykonanie walidacji danych przed utworzeniem projektu.
def projectResult = projectService.validateCreateProject(adminUser, projectData);

// Logowanie ewentualnych błędów w trakcie walidacji danych projektu.
if (!projectResult.isValid())
    log.warn projectResult.getErrorCollection().toString();

// 7. Utworzenie projektu.
Project project = projectService.createProject(projectResult);